/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.richclient.layout;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.richclient.application.ApplicationServicesLocator;
import org.springframework.richclient.factory.ComponentFactory;
import org.springframework.richclient.layout.LabelOrientation;
import org.springframework.richclient.layout.LayoutBuilder;
import org.springframework.richclient.util.GridBagLayoutDebugPanel;

public class GridBagLayoutBuilder
implements LayoutBuilder {
    private static final Log LOG = LogFactory.getLog((Class)GridBagLayoutBuilder.class);
    private Insets defaultInsets = new Insets(0, 0, 4, 4);
    private boolean showGuidelines = false;
    private boolean autoSpanLastComponent = true;
    private int currentCol;
    private int currentRow;
    private List rows;
    private List currentRowList;
    private int maxCol = 0;
    private ComponentFactory componentFactory;
    private static final Item NULL_ITEM = new Item(null, null);

    public GridBagLayoutBuilder() {
        this.init();
    }

    private void init() {
        this.currentCol = 0;
        this.currentRow = 0;
        this.rows = new ArrayList();
        this.currentRowList = new ArrayList();
    }

    public Insets getDefaultInsets() {
        return this.defaultInsets;
    }

    public void setDefaultInsets(Insets defaultInsets) {
        this.defaultInsets = defaultInsets;
    }

    public int getCurrentRow() {
        return this.currentRow;
    }

    public int getCurrentCol() {
        return this.currentCol;
    }

    public ComponentFactory getComponentFactory() {
        if (this.componentFactory == null) {
            this.componentFactory = (ComponentFactory)ApplicationServicesLocator.services().getService(ComponentFactory.class);
        }
        return this.componentFactory;
    }

    public void setComponentFactory(ComponentFactory componentFactory) {
        this.componentFactory = componentFactory;
    }

    public GridBagLayoutBuilder append(Component component) {
        return this.append(component, 1, 1);
    }

    public GridBagLayoutBuilder append(Component component, int colSpan, int rowSpan) {
        return this.append(component, colSpan, rowSpan, 0.0, 0.0);
    }

    public GridBagLayoutBuilder append(Component component, int colSpan, int rowSpan, boolean expandX, boolean expandY) {
        return this.append(component, colSpan, rowSpan, expandX, expandY, this.defaultInsets);
    }

    public GridBagLayoutBuilder append(Component component, int colSpan, int rowSpan, boolean expandX, boolean expandY, Insets insets) {
        if (expandX && expandY) {
            return this.append(component, colSpan, rowSpan, 1.0, 1.0, insets);
        }
        if (expandX) {
            return this.append(component, colSpan, rowSpan, 1.0, 0.0, insets);
        }
        if (expandY) {
            return this.append(component, colSpan, rowSpan, 0.0, 1.0, insets);
        }
        return this.append(component, colSpan, rowSpan, 0.0, 0.0, insets);
    }

    public GridBagLayoutBuilder append(Component component, int x, int y, int colSpan, int rowSpan, boolean expandX, boolean expandY, Insets insets) {
        if (expandX && expandY) {
            return this.append(component, x, y, colSpan, rowSpan, 1.0, 1.0, insets);
        }
        if (expandX) {
            return this.append(component, x, y, colSpan, rowSpan, 1.0, 0.0, insets);
        }
        if (expandY) {
            return this.append(component, x, y, colSpan, rowSpan, 0.0, 1.0, insets);
        }
        return this.append(component, x, y, colSpan, rowSpan, 0.0, 0.0, insets);
    }

    public GridBagLayoutBuilder append(Component component, int colSpan, int rowSpan, double xweight, double yweight) {
        return this.append(component, colSpan, rowSpan, xweight, yweight, this.defaultInsets);
    }

    public GridBagLayoutBuilder append(Component component, int colSpan, int rowSpan, double xweight, double yweight, Insets insets) {
        return this.append(component, this.getCurrentCol(), this.getCurrentRow(), colSpan, rowSpan, xweight, yweight, insets);
    }

    public GridBagLayoutBuilder appendLabeledField(String propertyName, JComponent field, LabelOrientation labelOrientation) {
        return this.appendLabeledField(propertyName, field, labelOrientation, 1);
    }

    public GridBagLayoutBuilder appendLabeledField(String propertyName, JComponent field, LabelOrientation labelOrientation, int colSpan) {
        return this.appendLabeledField(propertyName, field, labelOrientation, colSpan, 1, true, false);
    }

    public GridBagLayoutBuilder appendLabeledField(String propertyName, JComponent field, LabelOrientation labelOrientation, int colSpan, int rowSpan, boolean expandX, boolean expandY) {
        JLabel label = this.createLabel(propertyName);
        return this.appendLabeledField(label, field, labelOrientation, colSpan, rowSpan, expandX, expandY);
    }

    protected JLabel createLabel(String propertyName) {
        return this.getComponentFactory().createLabel(propertyName);
    }

    public GridBagLayoutBuilder appendLabeledField(JLabel label, JComponent field, LabelOrientation labelOrientation, int colSpan, int rowSpan, boolean expandX, boolean expandY) {
        label.setLabelFor(field);
        int col = this.getCurrentCol();
        int row = this.getCurrentRow();
        Insets insets = this.getDefaultInsets();
        if (labelOrientation == LabelOrientation.LEFT || labelOrientation == null) {
            label.setHorizontalAlignment(4);
            this.append((Component)label, col, row, 1, 1, false, expandY, insets);
            this.append((Component)field, col + 1, row, colSpan, rowSpan, expandX, expandY, insets);
        } else if (labelOrientation == LabelOrientation.RIGHT) {
            label.setHorizontalAlignment(2);
            this.append((Component)field, col, row, colSpan, rowSpan, expandX, expandY, insets);
            this.append((Component)label, col + colSpan, row, 1, rowSpan, false, expandY, insets);
        } else if (labelOrientation == LabelOrientation.TOP) {
            label.setHorizontalAlignment(2);
            this.append((Component)label, col, row, colSpan, 1, expandX, false, insets);
            this.append((Component)field, col, row + 1, colSpan, rowSpan, expandX, expandY, insets);
        } else if (labelOrientation == LabelOrientation.BOTTOM) {
            label.setHorizontalAlignment(2);
            this.append((Component)field, col, row, colSpan, rowSpan, expandX, expandY, insets);
            this.append((Component)label, col, row + rowSpan, colSpan, 1, expandX, false, insets);
        }
        return this;
    }

    public GridBagLayoutBuilder append(Component component, int x, int y, int colSpan, int rowSpan, double xweight, double yweight, Insets insets) {
        List rowList = this.getRow(y);
        this.ensureCapacity(rowList, Math.max(x, this.maxCol) + 1);
        int col = this.bypassPlaceholders(rowList, x);
        this.insertPlaceholdersIfNeeded(rowSpan, y, col, component, colSpan);
        GridBagConstraints gbc = this.createGridBagConstraint(col, y, colSpan, rowSpan, xweight, yweight, insets);
        rowList.set(col, new Item(component, gbc));
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)this.getDebugString(component, gbc));
        }
        this.maxCol = Math.max(this.maxCol, col);
        this.currentCol = col + colSpan;
        return this;
    }

    private void insertPlaceholdersIfNeeded(int rowSpan, int y, int col, Component component, int colSpan) {
        if (rowSpan > 1) {
            this.growRowsIfNeeded(rowSpan);
            for (int i = 1; i < y + rowSpan; ++i) {
                List row = this.getRow(i);
                this.ensureCapacity(row, col + colSpan + 1);
                if (row.get(col) != null) {
                    throw new IllegalStateException("Trying to overwrite another component: " + component + ", " + col + " " + y);
                }
                for (int j = 0; j < colSpan; ++j) {
                    row.set(col + j, NULL_ITEM);
                }
            }
        }
    }

    private List getRow(int i) {
        this.ensureCapacity(this.rows, i + 1);
        ArrayList row = (ArrayList)this.rows.get(i);
        if (row == null) {
            row = new ArrayList();
            this.rows.set(i, row);
        }
        return row;
    }

    private int bypassPlaceholders(List list, int col) {
        int theCol;
        for (theCol = col; theCol < list.size() && list.get(theCol) != null; ++theCol) {
        }
        return theCol;
    }

    private void ensureCapacity(List list, int minSize) {
        for (int i = list.size(); i < minSize; ++i) {
            list.add(null);
        }
    }

    private void growRowsIfNeeded(int rowSpan) {
        int minNeededSize = this.currentRow + rowSpan;
        this.ensureCapacity(this.rows, minNeededSize);
        int delta = minNeededSize - this.rows.size();
        if (delta > 0) {
            this.rows.set(this.currentRow, this.currentRowList);
            for (int i = 0; i < delta; ++i) {
                this.rows.set(this.currentRow + i, new ArrayList());
            }
        }
    }

    public GridBagLayoutBuilder appendLabel(JLabel label) {
        return this.appendLabel(label, 1);
    }

    public GridBagLayoutBuilder appendLabel(JLabel label, int colSpan) {
        return this.append((Component)label, colSpan, 1, false, false);
    }

    public GridBagLayoutBuilder appendRightLabel(String labelKey) {
        return this.appendRightLabel(labelKey, 1);
    }

    public GridBagLayoutBuilder appendRightLabel(String labelKey, int colSpan) {
        JLabel label = this.createLabel(labelKey);
        label.setHorizontalAlignment(4);
        return this.appendLabel(label, colSpan);
    }

    public GridBagLayoutBuilder appendLeftLabel(String labelKey) {
        return this.appendLeftLabel(labelKey, 1);
    }

    public GridBagLayoutBuilder appendLeftLabel(String labelKey, int colSpan) {
        JLabel label = this.createLabel(labelKey);
        label.setHorizontalAlignment(2);
        return this.appendLabel(label, colSpan);
    }

    public GridBagLayoutBuilder appendField(Component component) {
        return this.appendField(component, 1);
    }

    public GridBagLayoutBuilder appendField(Component component, int colSpan) {
        return this.append(component, colSpan, 1, true, false);
    }

    public GridBagLayoutBuilder appendSeparator() {
        return this.appendSeparator(null);
    }

    public GridBagLayoutBuilder appendSeparator(String labelKey) {
        if (this.currentRowList.size() > 0) {
            this.nextLine();
        }
        JComponent separator = this.getComponentFactory().createLabeledSeparator(labelKey);
        return this.append((Component)separator, 1, 1, true, false).nextLine();
    }

    public GridBagLayoutBuilder nextLine() {
        ++this.currentRow;
        this.currentCol = 0;
        return this;
    }

    private GridBagConstraints createGridBagConstraint(int x, int y, int colSpan, int rowSpan, double xweight, double yweight, Insets insets) {
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = x;
        gbc.gridy = y;
        gbc.gridwidth = colSpan;
        gbc.gridheight = rowSpan;
        gbc.weightx = xweight;
        gbc.weighty = yweight;
        gbc.insets = insets;
        gbc.fill = 1;
        return gbc;
    }

    public void setShowGuidelines(boolean showGuidelines) {
        this.showGuidelines = showGuidelines;
    }

    public JPanel getPanel() {
        if (this.currentRowList.size() > 0) {
            this.rows.add(this.currentRowList);
        }
        JPanel panel = this.showGuidelines ? new GridBagLayoutDebugPanel() : new JPanel(new GridBagLayout());
        int lastRowIndex = this.rows.size() - 1;
        for (int currentRowIndex = 0; currentRowIndex <= lastRowIndex; ++currentRowIndex) {
            List row = this.getRow(currentRowIndex);
            this.addRow(row, currentRowIndex, lastRowIndex, panel);
        }
        return panel;
    }

    private void addRow(List row, int currentRowIndex, int lastRowIndex, JPanel panel) {
        int lastColIndex = row.size() - 1;
        for (int currentColIndex = 0; currentColIndex <= lastColIndex; ++currentColIndex) {
            Item item = (Item)row.get(currentColIndex);
            if (item == null || item == NULL_ITEM) continue;
            GridBagConstraints gbc = item.gbc;
            if (gbc.gridy + gbc.gridheight - 1 == lastRowIndex) {
                this.formatLastRow(gbc);
            }
            if (gbc.gridx + gbc.gridwidth - 1 == lastColIndex) {
                this.formatLastColumn(gbc, currentColIndex);
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Adding to panel: " + this.getDebugString(item.component, gbc)));
            }
            panel.add(item.component, gbc);
        }
    }

    private String getDebugString(Component component, GridBagConstraints gbc) {
        StringBuffer buffer = new StringBuffer();
        if (component instanceof JComponent) {
            JComponent jcomp = (JComponent)component;
            String name = jcomp.getName();
            if (name != null && !"".equals(jcomp.getName())) {
                buffer.append(name);
            } else if (jcomp instanceof JLabel) {
                buffer.append(((JLabel)jcomp).getText());
            } else {
                buffer.append(jcomp.toString());
            }
        } else {
            buffer.append(component.toString());
        }
        buffer.append(", ");
        buffer.append("GridBagConstraint[");
        buffer.append("anchor=").append(gbc.anchor).append(",");
        buffer.append("fill=").append(gbc.fill).append(",");
        buffer.append("gridheight=").append(gbc.gridheight).append(",");
        buffer.append("gridwidth=").append(gbc.gridwidth).append(",");
        buffer.append("gridx=").append(gbc.gridx).append(",");
        buffer.append("gridy=").append(gbc.gridy).append(",");
        buffer.append("weightx=").append(gbc.weightx).append(",");
        buffer.append("weighty=").append(gbc.weighty).append("]");
        return buffer.toString();
    }

    private void formatLastRow(GridBagConstraints gbc) {
        Insets oldInset = gbc.insets;
        gbc.insets = new Insets(oldInset.top, oldInset.left, 0, oldInset.right);
    }

    public void setAutoSpanLastComponent(boolean autoSpanLastComponent) {
        this.autoSpanLastComponent = autoSpanLastComponent;
    }

    private void formatLastColumn(GridBagConstraints gbc, int currentColIndex) {
        int colSpan;
        Insets oldInset = gbc.insets;
        gbc.insets = new Insets(oldInset.top, oldInset.left, oldInset.bottom, 0);
        if (this.autoSpanLastComponent && (colSpan = this.maxCol - currentColIndex + 1) > gbc.gridwidth) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Increasing gridwidth from " + gbc.gridwidth + " to " + colSpan));
            }
            gbc.gridwidth = colSpan;
        }
    }

    private static class Item {
        public Component component;
        public GridBagConstraints gbc;

        public Item(Component component, GridBagConstraints gbc) {
            this.component = component;
            this.gbc = gbc;
        }
    }
}

