/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.richclient.layout;

import com.jgoodies.forms.factories.FormFactory;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.ColumnSpec;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.layout.RowSpec;
import java.awt.Component;
import java.awt.LayoutManager;
import java.io.IOException;
import java.io.StreamTokenizer;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.springframework.richclient.application.ApplicationServicesLocator;
import org.springframework.richclient.factory.ComponentFactory;
import org.springframework.richclient.layout.LayoutBuilder;
import org.springframework.richclient.util.CustomizableFocusTraversalPolicy;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class TableLayoutBuilder
implements LayoutBuilder {
    public static final String DEFAULT_LABEL_ATTRIBUTES = "colGrId=label colSpec=left:pref";
    public static final String ALIGN = "align";
    public static final String VALIGN = "valign";
    public static final String ROWSPEC = "rowSpec";
    public static final String COLSPEC = "colSpec";
    public static final String ROWSPAN = "rowSpan";
    public static final String COLSPAN = "colSpan";
    public static final String ROWGROUPID = "rowGrId";
    public static final String COLGROUPID = "colGrId";
    public static final int COLUMN_MAJOR_FOCUS_ORDER = 1;
    public static final int ROW_MAJOR_FOCUS_ORDER = 2;
    private List rowSpecs = new ArrayList();
    private List rowOccupiers = new ArrayList();
    private List columnSpecs = new ArrayList();
    private Map gapCols = new HashMap();
    private Map gapRows = new HashMap();
    private Map rowGroups = new HashMap();
    private Map colGroups = new HashMap();
    private int[][] adjustedColGroupIndices;
    private int[][] adjustedRowGroupIndices;
    private Cell lastCC = null;
    private int maxColumns = 0;
    private int currentRow = -1;
    private int currentCol = 0;
    private List items = new ArrayList();
    private JPanel panel;
    private List focusOrder = null;
    private ComponentFactory componentFactory;
    private static final Set allowedAttributes = new HashSet();

    public TableLayoutBuilder() {
        this.panel = null;
    }

    public TableLayoutBuilder(JPanel panel) {
        Assert.notNull((Object)panel, (String)"panel is required");
        this.panel = panel;
        panel.removeAll();
    }

    public ComponentFactory getComponentFactory() {
        if (this.componentFactory == null) {
            this.componentFactory = (ComponentFactory)ApplicationServicesLocator.services().getService(ComponentFactory.class);
        }
        return this.componentFactory;
    }

    public void setComponentFactory(ComponentFactory componentFactory) {
        this.componentFactory = componentFactory;
    }

    public int getCurrentRow() {
        return this.currentRow == -1 ? 0 : this.currentRow;
    }

    public int getCurrentCol() {
        return this.currentCol;
    }

    public TableLayoutBuilder row() {
        ++this.currentRow;
        this.lastCC = null;
        this.maxColumns = Math.max(this.maxColumns, this.currentCol);
        this.currentCol = 0;
        return this;
    }

    public TableLayoutBuilder row(String gapRowSpec) {
        return this.row(new RowSpec(gapRowSpec));
    }

    public TableLayoutBuilder row(RowSpec gapRowSpec) {
        this.row();
        this.gapRows.put(new Integer(this.currentRow), gapRowSpec);
        return this;
    }

    public TableLayoutBuilder relatedGapRow() {
        return this.row(FormFactory.RELATED_GAP_ROWSPEC);
    }

    public TableLayoutBuilder unrelatedGapRow() {
        return this.row(FormFactory.UNRELATED_GAP_ROWSPEC);
    }

    public TableLayoutBuilder cell() {
        return this.cell("");
    }

    public TableLayoutBuilder cell(String attributes) {
        this.cellInternal(null, attributes);
        return this;
    }

    public TableLayoutBuilder cell(JComponent component) {
        return this.cell(component, "");
    }

    public TableLayoutBuilder cell(JComponent component, String attributes) {
        Cell cc;
        this.lastCC = cc = this.cellInternal(component, attributes);
        this.items.add(cc);
        return this;
    }

    public TableLayoutBuilder gapCol() {
        return this.gapCol(FormFactory.RELATED_GAP_COLSPEC);
    }

    public TableLayoutBuilder gapCol(String colSpec) {
        return this.gapCol(new ColumnSpec(colSpec));
    }

    public TableLayoutBuilder gapCol(ColumnSpec colSpec) {
        this.gapCols.put(new Integer(this.currentCol), colSpec);
        return this;
    }

    public TableLayoutBuilder labelGapCol() {
        return this.gapCol(FormFactory.LABEL_COMPONENT_GAP_COLSPEC);
    }

    public TableLayoutBuilder unrelatedGapCol() {
        return this.gapCol(FormFactory.UNRELATED_GAP_COLSPEC);
    }

    public TableLayoutBuilder separator(String labelKey) {
        return this.separator(labelKey, "");
    }

    public TableLayoutBuilder separator(String labelKey, String attributes) {
        Cell cc;
        this.lastCC = cc = this.cellInternal(this.getComponentFactory().createLabeledSeparator(labelKey), attributes);
        this.items.add(cc);
        return this;
    }

    public boolean hasGapToLeft() {
        return this.currentCol == 0 || this.gapCols.get(new Integer(this.currentCol)) != null;
    }

    public boolean hasGapAbove() {
        return this.currentRow == 0 || this.gapRows.get(new Integer(this.currentRow)) != null;
    }

    public JPanel getPanel() {
        if (this.panel == null) {
            this.panel = this.getComponentFactory().createPanel();
        }
        this.insertMissingSpecs();
        this.fixColSpans();
        this.fillInGaps();
        this.fillPanel();
        if (this.focusOrder != null) {
            this.installFocusOrder(this.focusOrder);
        }
        return this.panel;
    }

    private Cell cellInternal(JComponent component, String attributes) {
        ColumnSpec columnSpec;
        this.nextCol();
        Map attributeMap = this.getAttributes(attributes);
        RowSpec rowSpec = this.getRowSpec(this.getAttribute(ROWSPEC, attributeMap, ""));
        if (rowSpec != null) {
            this.setRowSpec(this.currentRow, rowSpec);
        }
        if ((columnSpec = this.getColumnSpec(this.getAttribute(COLSPEC, attributeMap, ""))) != null) {
            this.setColumnSpec(this.currentCol, columnSpec);
        }
        this.addRowGroup(this.getAttribute(ROWGROUPID, attributeMap, null));
        this.addColGroup(this.getAttribute(COLGROUPID, attributeMap, null));
        Cell cc = this.createCell(component, attributeMap);
        this.currentCol = cc.endCol < cc.startCol ? cc.startCol : cc.endCol;
        this.markContained(cc);
        return cc;
    }

    private void addRowGroup(String groupId) {
        if (StringUtils.hasText((String)groupId)) {
            HashSet<Integer> group = (HashSet<Integer>)this.rowGroups.get(groupId);
            if (group == null) {
                group = new HashSet<Integer>();
                this.rowGroups.put(groupId, group);
            }
            group.add(new Integer(this.getCurrentRow()));
        }
    }

    private void addColGroup(String groupId) {
        if (StringUtils.hasText((String)groupId)) {
            HashSet<Integer> group = (HashSet<Integer>)this.colGroups.get(groupId);
            if (group == null) {
                group = new HashSet<Integer>();
                this.colGroups.put(groupId, group);
            }
            group.add(new Integer(this.currentCol));
        }
    }

    private void setRowSpec(int row, RowSpec rowSpec) {
        if (row >= this.rowSpecs.size()) {
            int missingSpecs = row - this.rowSpecs.size() + 1;
            for (int i = 0; i < missingSpecs; ++i) {
                this.rowSpecs.add(this.getDefaultRowSpec());
            }
        }
        this.rowSpecs.set(row, rowSpec);
    }

    private void setColumnSpec(int col, ColumnSpec columnSpec) {
        if (--col >= this.columnSpecs.size()) {
            int missingSpecs = col - this.columnSpecs.size() + 1;
            for (int i = 0; i < missingSpecs; ++i) {
                this.columnSpecs.add(this.getDefaultColSpec());
            }
        }
        this.columnSpecs.set(col, columnSpec);
    }

    private RowSpec getRowSpec(String rowSpec) {
        if (StringUtils.hasText((String)rowSpec)) {
            return new RowSpec(rowSpec);
        }
        return null;
    }

    private ColumnSpec getColumnSpec(String columnSpec) {
        if (StringUtils.hasText((String)columnSpec)) {
            return new ColumnSpec(columnSpec);
        }
        return null;
    }

    private void nextCol() {
        if (this.lastCC != null && this.lastCC.endCol < this.lastCC.startCol) {
            this.lastCC.endCol = this.lastCC.startCol;
            this.lastCC = null;
        }
        if (this.currentRow == -1) {
            this.row();
        }
        do {
            ++this.currentCol;
        } while (this.getOccupier(this.currentRow, this.currentCol) != null);
    }

    private Cell getOccupier(int row, int col) {
        List occupiers = this.getOccupiers(row);
        if (col >= occupiers.size()) {
            return null;
        }
        return (Cell)occupiers.get(col);
    }

    private List getOccupiers(int row) {
        if (row >= this.rowOccupiers.size()) {
            int numMissingRows = row - this.rowOccupiers.size() + 1;
            for (int i = 0; i < numMissingRows; ++i) {
                this.rowOccupiers.add(new ArrayList());
            }
        }
        return (List)this.rowOccupiers.get(row);
    }

    private void markContained(Cell cc) {
        this.setOccupier(cc, cc.startRow, cc.endRow, cc.startCol, cc.endCol < cc.startCol ? cc.startCol : cc.endCol);
    }

    private void setOccupier(Cell occupier, int startRow, int endRow, int startCol, int endCol) {
        for (int row = startRow; row <= endRow; ++row) {
            List occupiers = this.getOccupiers(row);
            if (endCol >= occupiers.size()) {
                int numMissingCols = endCol - occupiers.size() + 1;
                for (int i = 0; i < numMissingCols; ++i) {
                    occupiers.add(null);
                }
            }
            for (int i = startCol; i <= endCol; ++i) {
                occupiers.set(i, occupier);
            }
        }
    }

    private Cell createCell(JComponent component, Map attributes) {
        int rowSpan;
        int colSpan;
        String align = this.getAttribute(ALIGN, attributes, "default");
        String valign = this.getAttribute(VALIGN, attributes, "default");
        try {
            colSpan = Integer.parseInt(this.getAttribute(COLSPAN, attributes, "-1"));
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Attribute 'colspan' must be an integer.");
        }
        try {
            rowSpan = Integer.parseInt(this.getAttribute(ROWSPAN, attributes, "1"));
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Attribute 'rowspan' must be an integer.");
        }
        return new Cell(component, this.getCurrentCol(), this.getCurrentRow(), colSpan, rowSpan, align + "," + valign);
    }

    private void fixColSpans() {
        Iterator i = this.items.iterator();
        while (i.hasNext()) {
            Cell cc = (Cell)i.next();
            if (cc.endCol < cc.startCol) {
                int endCol;
                for (endCol = cc.startCol; endCol < this.maxColumns && this.getOccupier(cc.startRow, endCol + 1) == null; ++endCol) {
                }
                cc.endCol = endCol;
            }
            this.markContained(cc);
        }
    }

    private void fillInGaps() {
        Iterator j;
        int groupCount;
        Set group;
        ArrayList<Integer> adjustedCols = new ArrayList<Integer>();
        int adjustedCol = 0;
        int col = 0;
        while (col < this.maxColumns) {
            ColumnSpec colSpec = (ColumnSpec)this.gapCols.get(new Integer(col));
            if (colSpec != null) {
                this.columnSpecs.add(adjustedCol, colSpec);
                ++adjustedCol;
            }
            adjustedCols.add(new Integer(adjustedCol + 1));
            ++col;
            ++adjustedCol;
        }
        ArrayList<Integer> adjustedRows = new ArrayList<Integer>();
        int adjustedRow = 0;
        int numRows = this.rowSpecs.size();
        int row = 0;
        while (row < numRows) {
            RowSpec rowSpec = (RowSpec)this.gapRows.get(new Integer(row));
            if (rowSpec != null) {
                this.rowSpecs.add(adjustedRow, rowSpec);
                ++adjustedRow;
            }
            adjustedRows.add(new Integer(adjustedRow));
            ++row;
            ++adjustedRow;
        }
        Iterator i = this.items.iterator();
        while (i.hasNext()) {
            Cell cc = (Cell)i.next();
            cc.startCol = (Integer)adjustedCols.get(cc.startCol - 1);
            cc.endCol = (Integer)adjustedCols.get(cc.endCol - 1);
            cc.startRow = (Integer)adjustedRows.get(cc.startRow);
            cc.endRow = (Integer)adjustedRows.get(cc.endRow);
        }
        this.adjustedColGroupIndices = new int[this.colGroups.size()][];
        int groupsCount = 0;
        Iterator i2 = this.colGroups.values().iterator();
        while (i2.hasNext()) {
            group = (Set)i2.next();
            this.adjustedColGroupIndices[groupsCount] = new int[group.size()];
            groupCount = 0;
            j = group.iterator();
            while (j.hasNext()) {
                this.adjustedColGroupIndices[groupsCount][groupCount++] = (Integer)adjustedCols.get((Integer)j.next() - 1);
            }
            ++groupsCount;
        }
        this.adjustedRowGroupIndices = new int[this.rowGroups.size()][];
        groupsCount = 0;
        i2 = this.rowGroups.values().iterator();
        while (i2.hasNext()) {
            group = (Set)i2.next();
            this.adjustedRowGroupIndices[groupsCount] = new int[group.size()];
            groupCount = 0;
            j = group.iterator();
            while (j.hasNext()) {
                this.adjustedRowGroupIndices[groupsCount][groupCount++] = (Integer)adjustedRows.get((Integer)j.next() - 1);
            }
            ++groupsCount;
        }
    }

    public void setFocusTraversalOrder(int traversalOrder) {
        Assert.isTrue((traversalOrder == 1 || traversalOrder == 2 ? 1 : 0) != 0, (String)"traversalOrder must be one of COLUMN_MAJOR_FOCUS_ORDER or ROW_MAJOR_FOCUS_ORDER");
        ArrayList<Object> focusOrder = new ArrayList<Object>(this.items.size());
        if (traversalOrder == 2) {
            for (int row = 0; row < this.rowOccupiers.size() - 1; ++row) {
                for (int col = 0; col < this.maxColumns; ++col) {
                    Cell currentCell = this.getOccupier(row, col);
                    if (currentCell == null || focusOrder.contains(currentCell.getComponent())) continue;
                    focusOrder.add(currentCell.getComponent());
                }
            }
        } else if (traversalOrder == 1) {
            for (int col = 0; col < this.maxColumns; ++col) {
                for (int row = 0; row < this.rowOccupiers.size() - 1; ++row) {
                    Cell currentCell = this.getOccupier(row, col);
                    if (currentCell == null || focusOrder.contains(currentCell.getComponent())) continue;
                    focusOrder.add(currentCell.getComponent());
                }
            }
        }
        this.setCustomFocusTraversalOrder(focusOrder);
    }

    public void setCustomFocusTraversalOrder(List focusOrder) {
        this.focusOrder = focusOrder;
    }

    protected void installFocusOrder(List focusOrder) {
        CustomizableFocusTraversalPolicy.installCustomizableFocusTraversalPolicy();
        CustomizableFocusTraversalPolicy.customizeFocusTraversalOrder(this.panel, focusOrder);
    }

    private void fillPanel() {
        this.panel.setLayout((LayoutManager)this.createLayout());
        Iterator i = this.items.iterator();
        while (i.hasNext()) {
            Cell cc = (Cell)i.next();
            this.panel.add((Component)cc.getComponent(), cc.getCellConstraints());
        }
    }

    private FormLayout createLayout() {
        ColumnSpec[] columnSpecsArray = this.columnSpecs.toArray(new ColumnSpec[this.columnSpecs.size()]);
        RowSpec[] rowSpecArray = this.rowSpecs.toArray(new RowSpec[this.rowSpecs.size()]);
        FormLayout layout = new FormLayout(columnSpecsArray, rowSpecArray);
        layout.setColumnGroups(this.adjustedColGroupIndices);
        layout.setRowGroups(this.adjustedRowGroupIndices);
        return layout;
    }

    private void insertMissingSpecs() {
        this.maxColumns = Math.max(this.maxColumns, this.currentCol);
        if (this.columnSpecs.size() < this.maxColumns) {
            this.setColumnSpec(this.maxColumns, this.getDefaultColSpec());
        }
        if (this.rowSpecs.size() <= this.getCurrentRow()) {
            this.setRowSpec(this.getCurrentRow(), this.getDefaultRowSpec());
        }
    }

    private RowSpec getDefaultRowSpec() {
        return FormFactory.DEFAULT_ROWSPEC;
    }

    private ColumnSpec getDefaultColSpec() {
        return new ColumnSpec("default:grow");
    }

    private String getAttribute(String name, Map attributeMap, String defaultValue) {
        String value = (String)attributeMap.get(name.toLowerCase());
        if (value == null) {
            value = defaultValue;
        }
        return value;
    }

    private Map getAttributes(String attributes) {
        if (!StringUtils.hasText((String)attributes)) {
            return Collections.EMPTY_MAP;
        }
        HashMap<String, String> attributeMap = new HashMap<String, String>();
        try {
            StreamTokenizer st = new StreamTokenizer(new StringReader(attributes));
            st.resetSyntax();
            st.wordChars(33, 126);
            st.wordChars(160, 255);
            st.whitespaceChars(0, 32);
            st.quoteChar(34);
            st.quoteChar(39);
            st.ordinaryChar(61);
            String name = null;
            boolean needEquals = false;
            while (st.nextToken() != -1) {
                if (name == null && st.ttype == -3) {
                    name = st.sval;
                    if (!allowedAttributes.contains(name.toLowerCase())) {
                        throw new IllegalArgumentException("Attribute name '" + name + "' not recognised.");
                    }
                    needEquals = true;
                    continue;
                }
                if (needEquals && st.ttype == 61) {
                    needEquals = false;
                    continue;
                }
                if (name != null && (st.ttype == -3 || st.ttype == 39 | st.ttype == 34)) {
                    attributeMap.put(name.toLowerCase(), st.sval);
                    name = null;
                    continue;
                }
                throw new IllegalArgumentException("Expecting '=' but found '" + st.sval + "'");
            }
            if (needEquals || name != null) {
                throw new IllegalArgumentException("Premature end of string. Expecting " + (needEquals ? " '='." : " value for attribute '" + name + "'."));
            }
        }
        catch (IOException e) {
            throw new UnsupportedOperationException("Encountered unexpected IOException. " + e.getMessage());
        }
        return attributeMap;
    }

    static {
        allowedAttributes.add(COLSPAN.toLowerCase());
        allowedAttributes.add(ROWSPAN.toLowerCase());
        allowedAttributes.add(COLSPEC.toLowerCase());
        allowedAttributes.add(ROWSPEC.toLowerCase());
        allowedAttributes.add(ALIGN.toLowerCase());
        allowedAttributes.add(VALIGN.toLowerCase());
        allowedAttributes.add(ROWGROUPID.toLowerCase());
        allowedAttributes.add(COLGROUPID.toLowerCase());
    }

    private static class Cell {
        private JComponent component;
        private int startCol;
        private int startRow;
        private int endCol;
        private int endRow;
        private String align;

        public Cell(JComponent component, int x, int y, int w, int h, String align) {
            this.component = component;
            this.startCol = x;
            this.startRow = y;
            this.endCol = x + w - 1;
            this.endRow = y + h - 1;
            this.align = align;
        }

        public Object getComponent() {
            return this.component;
        }

        public CellConstraints getCellConstraints() {
            return new CellConstraints().xywh(this.startCol, this.startRow + 1, this.endCol - this.startCol + 1, this.endRow - this.startRow + 1, this.align);
        }
    }
}

