/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.richclient.list;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Collection;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.binding.value.ValueModel;
import org.springframework.binding.value.support.ValueHolder;
import org.springframework.richclient.list.ComboBoxListModel;

public class DynamicComboBoxListModel
extends ComboBoxListModel
implements PropertyChangeListener {
    private static final Log logger = LogFactory.getLog((Class)DynamicComboBoxListModel.class);
    private final SelectedItemChangeHandler selectedItemChangeHandler = new SelectedItemChangeHandler();
    private final ValueModel selectedItemHolder;
    private ValueModel selectableItemsHolder;

    public DynamicComboBoxListModel(ValueModel selectedItemHolder) {
        this(selectedItemHolder, (ValueModel)null);
    }

    public DynamicComboBoxListModel(ValueModel selectedItemHolder, List items) {
        this(selectedItemHolder, (ValueModel)new ValueHolder((Object)items));
    }

    public DynamicComboBoxListModel(ValueModel selectedItemHolder, ValueModel selectableItemsHolder) {
        this.selectedItemHolder = selectedItemHolder;
        if (selectedItemHolder != null) {
            selectedItemHolder.addValueChangeListener((PropertyChangeListener)this.selectedItemChangeHandler);
        }
        this.setSelectableItemsHolder(selectableItemsHolder);
    }

    public void setSelectableItemsHolder(ValueModel holder) {
        if (this.selectableItemsHolder == holder) {
            return;
        }
        if (this.selectableItemsHolder != null) {
            holder.removeValueChangeListener((PropertyChangeListener)this);
        }
        this.selectableItemsHolder = holder;
        if (this.selectableItemsHolder != null) {
            this.doAdd(holder.getValue());
            this.selectableItemsHolder.addValueChangeListener((PropertyChangeListener)this);
        }
    }

    public Object getSelectedItem() {
        if (this.selectedItemHolder != null) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Returning selected item " + this.selectedItemHolder.getValue()));
            }
            return this.selectedItemHolder.getValue();
        }
        return super.getSelectedItem();
    }

    public void setSelectedItem(Object selectedItem) {
        if (this.selectedItemHolder != null) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Setting newly selected item on value holder to " + selectedItem));
            }
            this.selectedItemHolder.setValue(selectedItem);
        } else {
            super.setSelectedItem(selectedItem);
        }
    }

    public void propertyChange(PropertyChangeEvent evt) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Backing collection of selectable items changed; refreshing combo box with contents of new collection.");
        }
        this.doAdd(this.selectableItemsHolder.getValue());
    }

    private void doAdd(Object items) {
        this.clear();
        if (items != null) {
            if (items instanceof Collection) {
                this.addAll((Collection)items);
            } else if (items instanceof Object[]) {
                Object[] itemsArray = (Object[])items;
                for (int i = 0; i < itemsArray.length; ++i) {
                    this.add(itemsArray[i]);
                }
            } else {
                throw new IllegalArgumentException("selectableItemsHolder must hold a Collection or array");
            }
        }
        this.sort();
    }

    private class SelectedItemChangeHandler
    implements PropertyChangeListener {
        private SelectedItemChangeHandler() {
        }

        public void propertyChange(PropertyChangeEvent evt) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Notifying combo box view selected value changed; new value is '" + DynamicComboBoxListModel.this.selectedItemHolder.getValue() + "'"));
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Firing contents change event; selected item may have changed");
            }
            DynamicComboBoxListModel.this.fireContentsChanged(this, -1, -1);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Fired contents change event!");
            }
        }
    }
}

