/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.richclient.list;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Collection;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.binding.value.ValueModel;
import org.springframework.binding.value.support.ListListModel;

public class DynamicListModel
extends ListListModel
implements PropertyChangeListener {
    private static final Log logger = LogFactory.getLog((Class)DynamicListModel.class);
    private ValueModel listItemsValueModel;

    public DynamicListModel(ValueModel listItemsValueModel) {
        this.setListItemsValueModel(listItemsValueModel);
    }

    public void setListItemsValueModel(ValueModel valueModel) {
        if (this.listItemsValueModel == valueModel) {
            return;
        }
        if (this.listItemsValueModel != null) {
            this.listItemsValueModel.removeValueChangeListener((PropertyChangeListener)this);
        }
        this.listItemsValueModel = valueModel;
        if (this.listItemsValueModel != null) {
            this.doAdd((Collection)valueModel.getValue());
            this.listItemsValueModel.addValueChangeListener((PropertyChangeListener)this);
        }
    }

    public void propertyChange(PropertyChangeEvent evt) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Backing collection of items changed; refreshing list model.");
        }
        this.doAdd((Collection)this.listItemsValueModel.getValue());
    }

    private void doAdd(Collection c) {
        this.clear();
        if (c != null) {
            this.addAll(c);
        }
        this.sort();
    }
}

