/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.richclient.list;

import java.awt.Component;
import java.awt.event.ActionListener;
import java.util.Locale;
import javax.swing.ComboBoxEditor;
import org.springframework.context.MessageSource;
import org.springframework.context.MessageSourceResolvable;
import org.springframework.core.enums.LabeledEnum;
import org.springframework.util.Assert;

public class LabeledEnumComboBoxEditor
implements ComboBoxEditor {
    private Object current;
    private MessageSource messages;
    private ComboBoxEditor inner;

    public LabeledEnumComboBoxEditor(MessageSource messageSource, ComboBoxEditor editor) {
        Assert.notNull((Object)editor, (String)"Editor cannot be null");
        this.inner = editor;
        this.messages = messageSource;
    }

    public void selectAll() {
        this.inner.selectAll();
    }

    public Component getEditorComponent() {
        return this.inner.getEditorComponent();
    }

    public void addActionListener(ActionListener l) {
        this.inner.addActionListener(l);
    }

    public void removeActionListener(ActionListener l) {
        this.inner.removeActionListener(l);
    }

    public Object getItem() {
        return this.current;
    }

    public void setItem(Object anObject) {
        this.current = anObject;
        if (anObject != null) {
            if (this.messages != null && anObject instanceof MessageSourceResolvable) {
                this.inner.setItem(this.messages.getMessage((MessageSourceResolvable)anObject, Locale.getDefault()));
            } else {
                this.inner.setItem(((LabeledEnum)anObject).getLabel());
            }
        } else {
            this.inner.setItem(null);
        }
    }
}

