/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.richclient.progress;

import javax.swing.JProgressBar;
import org.springframework.richclient.progress.ProgressMonitor;
import org.springframework.util.Assert;

public class ProgressBarProgressMonitor
implements ProgressMonitor {
    private JProgressBar progressBar;
    private boolean canceled;

    public ProgressBarProgressMonitor(JProgressBar progressBar) {
        Assert.notNull((Object)progressBar, (String)"ProgressBar cannot be null.");
        this.progressBar = progressBar;
    }

    public JProgressBar getProgressBar() {
        return this.progressBar;
    }

    public boolean isCanceled() {
        return this.canceled;
    }

    public void setCanceled(boolean b) {
        this.canceled = b;
    }

    public void done() {
    }

    public void subTaskStarted(String name) {
        this.progressBar.setString(name);
    }

    public void taskStarted(String name, int totalWork) {
        this.progressBar.setIndeterminate(false);
        this.progressBar.setMinimum(0);
        this.progressBar.setMaximum(totalWork);
        this.progressBar.setString(name);
    }

    public void worked(int work) {
        this.progressBar.setValue(this.progressBar.getValue() + work);
    }
}

