/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.richclient.security;

import org.acegisecurity.Authentication;
import org.springframework.richclient.command.ActionCommand;
import org.springframework.richclient.command.support.ApplicationWindowAwareCommand;
import org.springframework.richclient.dialog.ApplicationDialog;
import org.springframework.richclient.dialog.TabbedDialogPage;
import org.springframework.richclient.dialog.TitledPageApplicationDialog;
import org.springframework.richclient.security.ApplicationSecurityManager;
import org.springframework.richclient.security.LoginForm;

public class LoginCommand
extends ApplicationWindowAwareCommand {
    private static final String ID = "loginCommand";
    private boolean displaySuccessMessage = true;
    private boolean closeOnCancel = true;
    private boolean clearPasswordOnFailure = true;
    private String defaultUserName = null;
    private ApplicationDialog dialog = null;
    static /* synthetic */ Class class$org$springframework$richclient$security$ApplicationSecurityManager;

    public LoginCommand() {
        super(ID);
    }

    public void setDisplaySuccess(boolean displaySuccessMessage) {
        this.displaySuccessMessage = displaySuccessMessage;
    }

    protected void doExecuteCommand() {
        TabbedDialogPage tabbedPage = new TabbedDialogPage("loginForm");
        final LoginForm loginForm = this.createLoginForm();
        tabbedPage.addForm(loginForm);
        if (this.getDefaultUserName() != null) {
            loginForm.setUserName(this.getDefaultUserName());
        }
        this.dialog = new TitledPageApplicationDialog(tabbedPage){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected boolean onFinish() {
                loginForm.commit();
                Authentication authentication = loginForm.getAuthentication();
                ApplicationSecurityManager sm = (ApplicationSecurityManager)this.getService(class$org$springframework$richclient$security$ApplicationSecurityManager == null ? (class$org$springframework$richclient$security$ApplicationSecurityManager = LoginCommand.class$("org.springframework.richclient.security.ApplicationSecurityManager")) : class$org$springframework$richclient$security$ApplicationSecurityManager);
                try {
                    sm.doLogin(authentication);
                    LoginCommand.this.postLogin();
                    boolean bl = true;
                    return bl;
                }
                finally {
                    if (LoginCommand.this.isClearPasswordOnFailure()) {
                        loginForm.setPassword("");
                    }
                    loginForm.requestFocusInWindow();
                }
            }

            protected void onCancel() {
                ApplicationSecurityManager sm;
                Authentication authentication;
                super.onCancel();
                if (LoginCommand.this.isCloseOnCancel() && (authentication = (sm = (ApplicationSecurityManager)this.getService(class$org$springframework$richclient$security$ApplicationSecurityManager == null ? (class$org$springframework$richclient$security$ApplicationSecurityManager = LoginCommand.class$("org.springframework.richclient.security.ApplicationSecurityManager")) : class$org$springframework$richclient$security$ApplicationSecurityManager)).getAuthentication()) == null) {
                    LoginCommand.this.logger.info((Object)"User canceled login; close the application.");
                    this.getApplication().close();
                }
            }

            protected ActionCommand getCallingCommand() {
                return LoginCommand.this;
            }

            protected void onAboutToShow() {
                loginForm.requestFocusInWindow();
            }
        };
        this.dialog.setDisplayFinishSuccessMessage(this.displaySuccessMessage);
        this.dialog.showDialog();
    }

    protected LoginForm createLoginForm() {
        return new LoginForm();
    }

    protected ApplicationDialog getDialog() {
        return this.dialog;
    }

    protected void postLogin() {
    }

    public boolean isCloseOnCancel() {
        return this.closeOnCancel;
    }

    public void setCloseOnCancel(boolean closeOnCancel) {
        this.closeOnCancel = closeOnCancel;
    }

    public boolean isClearPasswordOnFailure() {
        return this.clearPasswordOnFailure;
    }

    public void setClearPasswordOnFailure(boolean clearPasswordOnFailure) {
        this.clearPasswordOnFailure = clearPasswordOnFailure;
    }

    public String getDefaultUserName() {
        return this.defaultUserName;
    }

    public void setDefaultUserName(String defaultUserName) {
        this.defaultUserName = defaultUserName;
    }
}

