/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.richclient.security.support;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.richclient.application.Application;
import org.springframework.richclient.security.SecurityController;
import org.springframework.richclient.security.SecurityControllerManager;

public class DefaultSecurityControllerManager
implements SecurityControllerManager {
    private Map securityControllerMap = new HashMap();
    private SecurityController fallbackController = null;

    public void setSecurityControllerMap(Map map) {
        Iterator i = map.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry entry = i.next();
            this.registerSecurityControllerAlias((String)entry.getKey(), (SecurityController)entry.getValue());
        }
    }

    public SecurityController getSecurityController(String id) {
        SecurityController sc = (SecurityController)this.securityControllerMap.get(id);
        if (sc == null) {
            try {
                sc = (SecurityController)Application.instance().getApplicationContext().getBean(id, SecurityController.class);
            }
            catch (NoSuchBeanDefinitionException e) {
                sc = this.getFallbackSecurityController();
            }
        }
        return sc;
    }

    public void registerSecurityControllerAlias(String aliasId, SecurityController securityController) {
        this.securityControllerMap.put(aliasId, securityController);
    }

    public void setFallbackSecurityController(SecurityController fallbackController) {
        this.fallbackController = fallbackController;
    }

    public SecurityController getFallbackSecurityController() {
        return this.fallbackController;
    }
}

