/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.richclient.table.renderer;

import java.awt.Component;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeanWrapper;
import org.springframework.beans.BeanWrapperImpl;

public class BeanTableCellRenderer
extends DefaultTableCellRenderer {
    private static final Log log = LogFactory.getLog((Class)BeanTableCellRenderer.class);
    private BeanWrapper beanWrapper;

    public BeanTableCellRenderer() {
    }

    public BeanTableCellRenderer(BeanWrapper wrapper) {
        this.beanWrapper = wrapper;
    }

    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        if (value != null) {
            if (this.beanWrapper == null) {
                this.beanWrapper = new BeanWrapperImpl(value);
            } else {
                this.beanWrapper.setWrappedInstance(value);
            }
            try {
                BeanInfo info = Introspector.getBeanInfo(value.getClass());
                int index = info.getDefaultPropertyIndex();
                if (index != -1) {
                    String defaultPropName = this.beanWrapper.getPropertyDescriptors()[index].getName();
                    Object val = this.beanWrapper.getPropertyValue(defaultPropName);
                    TableCellRenderer r = table.getDefaultRenderer(val.getClass());
                    return r.getTableCellRendererComponent(table, val, isSelected, hasFocus, row, column);
                }
            }
            catch (IntrospectionException e) {
                log.debug((Object)("Error during introspection of bean: " + e.getMessage()), (Throwable)e);
            }
        }
        return super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
    }
}

