/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.richclient.text;

import java.net.URL;
import javax.swing.JTextPane;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.springframework.richclient.util.BrowserLauncher;

public class DefaultHyperlinkActivationHandler
implements HyperlinkListener {
    protected void handleAnchorActivated(HyperlinkEvent e, String anchor) {
        ((JTextPane)e.getSource()).scrollToReference(anchor);
    }

    protected void handleUrlActivated(HyperlinkEvent e, URL url) {
        BrowserLauncher.openURL(url);
    }

    protected void handleOtheActivated(HyperlinkEvent e) {
    }

    public void hyperlinkUpdate(HyperlinkEvent e) {
        if (e.getEventType().equals(HyperlinkEvent.EventType.ACTIVATED)) {
            if (e.getDescription().startsWith("#")) {
                this.handleAnchorActivated(e, e.getDescription().substring(1));
            } else if (e.getURL() != null) {
                this.handleUrlActivated(e, e.getURL());
            } else {
                this.handleOtheActivated(e);
            }
        }
    }
}

