/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.richclient.text;

import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.io.StringReader;
import javax.swing.JTextPane;
import javax.swing.UIManager;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.Caret;
import javax.swing.text.DefaultCaret;
import javax.swing.text.html.HTMLDocument;
import org.springframework.richclient.text.DefaultHyperlinkActivationHandler;
import org.springframework.richclient.text.SynchronousHTMLEditorKit;

public class HtmlPane
extends JTextPane {
    private boolean antiAlias;
    private Caret caret;
    private boolean allowSelection;

    public HtmlPane() {
        this(true);
    }

    public HtmlPane(boolean installHyperlinkActivationHandler) {
        this.setEditorKit(new SynchronousHTMLEditorKit());
        this.setEditable(false);
        this.installLaFStyleSheet();
        HyperlinkEnterExitBugFixer bugFixer = new HyperlinkEnterExitBugFixer();
        this.addMouseListener(bugFixer);
        this.addHyperlinkListener(bugFixer);
        if (installHyperlinkActivationHandler) {
            DefaultHyperlinkActivationHandler hyperlinkActivationHandler = new DefaultHyperlinkActivationHandler();
            this.addHyperlinkListener(hyperlinkActivationHandler);
        }
    }

    public boolean getAntiAlias() {
        return this.antiAlias;
    }

    public void setAntiAlias(boolean antiAlias) {
        if (this.antiAlias == antiAlias) {
            return;
        }
        this.antiAlias = antiAlias;
        this.firePropertyChange("antiAlias", !antiAlias, antiAlias);
        this.repaint();
    }

    public boolean getAllowSelection() {
        return this.allowSelection;
    }

    public void setAllowSelection(boolean allowSelection) {
        if (this.allowSelection == allowSelection) {
            return;
        }
        this.allowSelection = allowSelection;
        this.setCaretInternal();
        this.firePropertyChange("allowSelection", !allowSelection, allowSelection);
    }

    public void setCaret(Caret caret) {
        this.caret = caret;
        this.setCaretInternal();
    }

    public Caret getCaret() {
        return this.caret;
    }

    private void setCaretInternal() {
        if (this.allowSelection) {
            super.setCaret(this.caret);
        } else {
            super.setCaret(new NoSelectionCaret());
        }
    }

    protected void installLaFStyleSheet() {
        Font defaultFont = UIManager.getFont("Button.font");
        String stylesheet = "body {  font-family: " + defaultFont.getName() + "; font-size: " + defaultFont.getSize() + "pt;  }" + "a, p, li { font-family: " + defaultFont.getName() + "; font-size: " + defaultFont.getSize() + "pt;  }";
        try {
            ((HTMLDocument)this.getDocument()).getStyleSheet().loadRules(new StringReader(stylesheet), null);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void paintComponent(Graphics g) {
        if (this.antiAlias) {
            Graphics2D g2 = (Graphics2D)g;
            g2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            g2.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        }
        super.paintComponent(g);
    }

    private class HyperlinkEnterExitBugFixer
    extends MouseAdapter
    implements HyperlinkListener {
        private boolean hyperlinkActive;

        private HyperlinkEnterExitBugFixer() {
        }

        public void mouseExited(MouseEvent e) {
            if (this.hyperlinkActive) {
                HtmlPane.this.fireHyperlinkUpdate(new HyperlinkEvent(HtmlPane.this, HyperlinkEvent.EventType.EXITED, null));
                this.hyperlinkActive = true;
            }
        }

        public void mouseEntered(MouseEvent e) {
            if (this.hyperlinkActive) {
                HtmlPane.this.fireHyperlinkUpdate(new HyperlinkEvent(HtmlPane.this, HyperlinkEvent.EventType.ENTERED, null));
            }
        }

        public void hyperlinkUpdate(HyperlinkEvent e) {
            if (e.getEventType().equals(HyperlinkEvent.EventType.ENTERED)) {
                this.hyperlinkActive = true;
            } else if (e.getEventType().equals(HyperlinkEvent.EventType.EXITED)) {
                this.hyperlinkActive = false;
            }
        }
    }

    private static class NoSelectionCaret
    extends DefaultCaret {
        private NoSelectionCaret() {
        }

        public void mouseDragged(MouseEvent e) {
        }

        public void mouseMoved(MouseEvent e) {
        }

        public void mouseClicked(MouseEvent e) {
        }
    }
}

