/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.richclient.util;

import java.awt.Component;
import javax.swing.JList;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.ListCellRenderer;
import javax.swing.table.TableCellRenderer;
import javax.swing.tree.TreeCellRenderer;
import org.springframework.util.Assert;

public abstract class AbstractCellRenderer
implements TreeCellRenderer,
TableCellRenderer,
ListCellRenderer {
    private TableCellRenderer tableCellRenderer;
    private ListCellRenderer listCellRenderer;
    private TreeCellRenderer treeCellRenderer;

    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        if (this.treeCellRenderer == null) {
            this.treeCellRenderer = this.createTreeCellRenderer();
            Assert.notNull((Object)this.treeCellRenderer, (String)"Cell renderer implementation has not been configured for trees?");
        }
        return this.treeCellRenderer.getTreeCellRendererComponent(tree, value, selected, expanded, leaf, row, hasFocus);
    }

    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        if (this.tableCellRenderer == null) {
            this.tableCellRenderer = this.createTableCellRenderer();
            Assert.notNull((Object)this.tableCellRenderer, (String)"Cell renderer implementation has not been configured for tables?");
        }
        return this.tableCellRenderer.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
    }

    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        if (this.listCellRenderer == null) {
            this.listCellRenderer = this.createListCellRenderer();
            Assert.notNull((Object)this.listCellRenderer, (String)"Cell renderer has not been configured for lists?");
        }
        return this.listCellRenderer.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
    }

    protected ListCellRenderer createListCellRenderer() {
        return null;
    }

    protected TableCellRenderer createTableCellRenderer() {
        return null;
    }

    protected TreeCellRenderer createTreeCellRenderer() {
        return null;
    }
}

