/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.richclient.util;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.GridBagLayout;
import java.awt.Point;
import javax.swing.JPanel;

public class GridBagLayoutDebugPanel
extends JPanel {
    private Color gridColor = Color.red;

    public GridBagLayoutDebugPanel() {
        super(new GridBagLayout());
    }

    public void setGridColor(Color color) {
        this.gridColor = color;
    }

    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        this.paintGrid(g);
    }

    private void paintGrid(Graphics g) {
        if (!(this.getLayout() instanceof GridBagLayout)) {
            return;
        }
        GridBagLayout layout = (GridBagLayout)this.getLayout();
        int[][] layoutDimensions = layout.getLayoutDimensions();
        int[] columnWidths = layoutDimensions[0];
        int[] rowHeights = layoutDimensions[1];
        Point layoutOrigin = layout.getLayoutOrigin();
        int left = layoutOrigin.x;
        int top = layoutOrigin.y;
        g.setColor(this.gridColor);
        int width = 0;
        for (int i = 0; i < columnWidths.length; ++i) {
            width += columnWidths[i];
        }
        int height = 0;
        for (int i = 0; i < rowHeights.length; ++i) {
            height += rowHeights[i];
        }
        int x = left;
        for (int i = 0; i < columnWidths.length; ++i) {
            g.fillRect(x += columnWidths[i], top, 1, height);
        }
        int y = top;
        for (int i = 0; i < rowHeights.length; ++i) {
            g.fillRect(left, y += rowHeights[i], width, 1);
        }
    }
}

