/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.richclient.util;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.HierarchyBoundsListener;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.SwingConstants;
import javax.swing.SwingUtilities;

public class OverlayHelper
implements SwingConstants {
    private final OverlayTargetChangeHandler overlayTargetChangeHandler = new OverlayTargetChangeHandler();
    private final OverlayChangeHandler overlayChangeHandler = new OverlayChangeHandler();
    protected final JComponent overlay;
    protected final JComponent overlayClipper;
    protected final JComponent overlayTarget;
    private final int center;
    private final int xOffset;
    private final int yOffset;
    boolean isUpdating;
    private Runnable overlayUpdater = new OverlayUpdater();

    public static void attachOverlay(JComponent overlay, JComponent overlayTarget, int center, int xOffset, int yOffset) {
        new OverlayHelper(overlay, overlayTarget, center, xOffset, yOffset);
    }

    protected OverlayHelper(JComponent overlay, JComponent overlayTarget, int center, int xOffset, int yOffset) {
        this.overlay = overlay;
        this.overlayTarget = overlayTarget;
        this.center = center;
        this.xOffset = xOffset;
        this.yOffset = yOffset;
        this.overlayClipper = new JPanel();
        this.overlayClipper.setLayout(null);
        this.overlayClipper.add(overlay);
        this.overlayClipper.setOpaque(false);
        this.installListeners();
    }

    private void installListeners() {
        this.overlayTarget.addHierarchyListener(this.overlayTargetChangeHandler);
        this.overlayTarget.addHierarchyBoundsListener(this.overlayTargetChangeHandler);
        this.overlayTarget.addComponentListener(this.overlayTargetChangeHandler);
        this.overlay.addComponentListener(this.overlayChangeHandler);
        this.overlay.addPropertyChangeListener(this.overlayChangeHandler);
    }

    void updateOverlay() {
        if (this.isUpdating) {
            return;
        }
        this.isUpdating = true;
        SwingUtilities.invokeLater(this.overlayUpdater);
    }

    void putOverlay(JLayeredPane layeredPane) {
        JComponent parent;
        if (this.overlay.getParent() != this.overlayClipper) {
            parent = (JComponent)this.overlay.getParent();
            if (parent != null) {
                parent.remove(this.overlay);
            }
            this.overlayClipper.add(this.overlay);
        }
        if (this.overlayClipper.getParent() != layeredPane) {
            parent = (JComponent)this.overlayClipper.getParent();
            if (parent != null) {
                parent.remove(this.overlayClipper);
            }
            layeredPane.add(this.overlayClipper);
            layeredPane.setLayer(this.overlayClipper, JLayeredPane.PALETTE_LAYER);
        }
    }

    void positionOverlay(JLayeredPane layeredPane) {
        int centerX = this.xOffset;
        int centerY = this.yOffset;
        Rectangle overlayTargetBounds = new Rectangle(0, 0, this.overlayTarget.getWidth(), this.overlayTarget.getHeight());
        switch (this.center) {
            case 1: 
            case 2: 
            case 8: {
                centerY += overlayTargetBounds.y;
                break;
            }
            case 0: 
            case 3: 
            case 7: {
                centerY += overlayTargetBounds.y + overlayTargetBounds.height / 2;
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                centerY += overlayTargetBounds.y + overlayTargetBounds.height;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown value for center [" + this.center + "]");
            }
        }
        switch (this.center) {
            case 6: 
            case 7: 
            case 8: {
                centerX += overlayTargetBounds.x;
                break;
            }
            case 0: 
            case 1: 
            case 5: {
                centerX += overlayTargetBounds.x + overlayTargetBounds.width / 2;
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                centerX += overlayTargetBounds.x + overlayTargetBounds.width;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown value for center [" + this.center + "]");
            }
        }
        Dimension size = this.overlay.getPreferredSize();
        Rectangle newBound = new Rectangle(centerX - size.width / 2, centerY - size.height / 2, size.width, size.height);
        Rectangle visibleRect = this.findLargestVisibleRectFor(newBound);
        int offsetx = 0;
        int offsety = 0;
        if (visibleRect != null) {
            if (newBound.y < visibleRect.y) {
                offsety += visibleRect.y - newBound.y;
            }
            if (newBound.x < visibleRect.x) {
                offsetx += visibleRect.x - newBound.x;
            }
            newBound = newBound.intersection(visibleRect);
        } else {
            newBound.height = 0;
            newBound.width = 0;
        }
        Point pt = SwingUtilities.convertPoint(this.overlayTarget, newBound.x, newBound.y, layeredPane);
        newBound.x = pt.x;
        newBound.y = pt.y;
        this.setOverlayBounds(newBound, offsetx, offsety);
    }

    private Rectangle findLargestVisibleRectFor(Rectangle overlayRect) {
        Rectangle visibleRect = null;
        int curxoffset = 0;
        int curyoffset = 0;
        JComponent comp = this.overlayTarget;
        while (comp != null && !(comp instanceof JViewport) && !(comp instanceof JScrollPane)) {
            visibleRect = comp.getVisibleRect();
            visibleRect.x -= curxoffset;
            visibleRect.y -= curyoffset;
            if (visibleRect.contains(overlayRect)) {
                return visibleRect;
            }
            curxoffset += comp.getX();
            curyoffset += comp.getY();
            comp = comp.getParent() instanceof JComponent ? (JComponent)comp.getParent() : null;
        }
        return visibleRect;
    }

    private void setOverlayBounds(Rectangle newBounds, int xoffset, int yoffset) {
        Dimension preferred = this.overlay.getPreferredSize();
        Rectangle overlayBounds = new Rectangle(-xoffset, -yoffset, preferred.width, preferred.height);
        if (!overlayBounds.equals(this.overlay.getBounds())) {
            this.overlay.setBounds(overlayBounds);
        }
        if (!newBounds.equals(this.overlayClipper.getBounds())) {
            this.overlayClipper.setBounds(newBounds);
        }
    }

    void hideOverlay() {
        this.setOverlayBounds(new Rectangle(0, 0, 0, 0), 0, 0);
    }

    void removeOverlay() {
        if (this.overlay.getParent() != this.overlayClipper && this.overlay.getParent() != null) {
            this.overlay.getParent().remove(this.overlay);
        }
        if (this.overlayClipper.getParent() != null) {
            this.overlayClipper.getParent().remove(this.overlayClipper);
        }
    }

    protected Container getOverlayCapableParent(JComponent component) {
        Container overlayCapableParent;
        for (overlayCapableParent = component.getParent(); overlayCapableParent != null && !(overlayCapableParent instanceof JRootPane); overlayCapableParent = overlayCapableParent.getParent()) {
        }
        return overlayCapableParent;
    }

    protected JLayeredPane getLayeredPane(Container overlayCapableParent) {
        if (overlayCapableParent instanceof JRootPane) {
            return ((JRootPane)overlayCapableParent).getLayeredPane();
        }
        throw new IllegalArgumentException("Don't know how to handle parent of type [" + overlayCapableParent.getClass().getName() + "].");
    }

    class OverlayUpdater
    implements Runnable {
        OverlayUpdater() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                Container overlayCapableParent = OverlayHelper.this.getOverlayCapableParent(OverlayHelper.this.overlayTarget);
                if (overlayCapableParent == null) {
                    OverlayHelper.this.removeOverlay();
                } else if (!OverlayHelper.this.overlayTarget.isShowing() || !OverlayHelper.this.overlay.isVisible()) {
                    OverlayHelper.this.hideOverlay();
                } else {
                    JLayeredPane layeredPane = OverlayHelper.this.getLayeredPane(overlayCapableParent);
                    if (layeredPane.isVisible() && layeredPane.isShowing()) {
                        OverlayHelper.this.putOverlay(layeredPane);
                        OverlayHelper.this.positionOverlay(layeredPane);
                    }
                }
            }
            finally {
                OverlayHelper.this.isUpdating = false;
            }
        }
    }

    public static class SingleComponentLayoutManager
    implements LayoutManager {
        private Component singleComponent;

        public SingleComponentLayoutManager(Component singleComponent) {
            this.singleComponent = singleComponent;
        }

        public void removeLayoutComponent(Component comp) {
        }

        public void addLayoutComponent(String name, Component comp) {
        }

        public void layoutContainer(Container parent) {
            this.singleComponent.setBounds(0, 0, parent.getWidth(), parent.getHeight());
        }

        public Dimension minimumLayoutSize(Container parent) {
            return this.singleComponent.getMinimumSize();
        }

        public Dimension preferredLayoutSize(Container parent) {
            return this.singleComponent.getPreferredSize();
        }
    }

    class OverlayTargetChangeHandler
    implements HierarchyListener,
    HierarchyBoundsListener,
    ComponentListener {
        OverlayTargetChangeHandler() {
        }

        public void hierarchyChanged(HierarchyEvent e) {
            OverlayHelper.this.updateOverlay();
        }

        public void ancestorMoved(HierarchyEvent e) {
            OverlayHelper.this.updateOverlay();
        }

        public void ancestorResized(HierarchyEvent e) {
            OverlayHelper.this.updateOverlay();
        }

        public void componentHidden(ComponentEvent e) {
            OverlayHelper.this.hideOverlay();
        }

        public void componentMoved(ComponentEvent e) {
            OverlayHelper.this.updateOverlay();
        }

        public void componentResized(ComponentEvent e) {
            OverlayHelper.this.updateOverlay();
        }

        public void componentShown(ComponentEvent e) {
            OverlayHelper.this.updateOverlay();
        }
    }

    final class OverlayChangeHandler
    implements ComponentListener,
    PropertyChangeListener {
        OverlayChangeHandler() {
        }

        public void componentHidden(ComponentEvent e) {
            OverlayHelper.this.hideOverlay();
        }

        public void componentMoved(ComponentEvent e) {
        }

        public void componentResized(ComponentEvent e) {
        }

        public void componentShown(ComponentEvent e) {
            OverlayHelper.this.updateOverlay();
        }

        public void propertyChange(PropertyChangeEvent e) {
            if ("ancestor".equals(e.getPropertyName()) || "layeredContainerLayer".equals(e.getPropertyName())) {
                return;
            }
            OverlayHelper.this.updateOverlay();
        }
    }
}

