/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.richclient.wizard;

import java.awt.Image;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.springframework.richclient.application.support.ApplicationServicesAccessor;
import org.springframework.richclient.core.TitleConfigurable;
import org.springframework.richclient.form.Form;
import org.springframework.richclient.util.EventListenerListHelper;
import org.springframework.richclient.wizard.FormBackedWizardPage;
import org.springframework.richclient.wizard.Wizard;
import org.springframework.richclient.wizard.WizardContainer;
import org.springframework.richclient.wizard.WizardListener;
import org.springframework.richclient.wizard.WizardPage;
import org.springframework.util.Assert;

public abstract class AbstractWizard
extends ApplicationServicesAccessor
implements Wizard,
TitleConfigurable {
    public static final String DEFAULT_IMAGE_KEY = "wizard.pageIcon";
    private String wizardId;
    private String title;
    private boolean forcePreviousAndNextButtons;
    private List pages = new ArrayList(6);
    private WizardContainer container;
    private EventListenerListHelper listeners = new EventListenerListHelper(WizardListener.class);
    private boolean autoConfigureChildPages = true;

    public AbstractWizard() {
        this(null);
    }

    public AbstractWizard(String wizardId) {
        this.wizardId = wizardId;
    }

    public String getId() {
        return this.wizardId;
    }

    public void setAutoConfigureChildPages(boolean autoConfigure) {
        this.autoConfigureChildPages = autoConfigure;
    }

    public void setForcePreviousAndNextButtons(boolean b) {
        this.forcePreviousAndNextButtons = b;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String newTitle) {
        this.title = newTitle;
    }

    public WizardContainer getContainer() {
        return this.container;
    }

    public void setContainer(WizardContainer container) {
        this.container = container;
    }

    public void addPage(WizardPage page) {
        this.addPage(this.getId(), page);
    }

    protected void addPage(String wizardConfigurationKey, WizardPage page) {
        this.pages.add(page);
        page.setWizard(this);
        if (this.autoConfigureChildPages) {
            String key = (wizardConfigurationKey != null ? wizardConfigurationKey + "." : "") + page.getId();
            this.getObjectConfigurer().configure(page, key);
        }
    }

    public WizardPage addForm(Form formPage) {
        Assert.notNull((Object)formPage, (String)"The form page cannot be null");
        FormBackedWizardPage page = new FormBackedWizardPage(formPage, !this.autoConfigureChildPages);
        this.addPage(page);
        return page;
    }

    public void removePage(WizardPage page) {
        if (this.pages.remove(page)) {
            page.setWizard(null);
        }
    }

    public void addPages() {
    }

    public boolean canFinish() {
        for (int i = 0; i < this.pages.size(); ++i) {
            if (((WizardPage)this.pages.get(i)).isPageComplete()) continue;
            return false;
        }
        return true;
    }

    public Image getDefaultPageImage() {
        return this.getImageSource().getImage(DEFAULT_IMAGE_KEY);
    }

    public WizardPage getNextPage(WizardPage page) {
        int index = this.pages.indexOf(page);
        if (index == this.pages.size() - 1 || index == -1) {
            return null;
        }
        return (WizardPage)this.pages.get(index + 1);
    }

    public WizardPage getPage(String pageId) {
        Iterator it = this.pages.iterator();
        while (it.hasNext()) {
            WizardPage page = (WizardPage)it.next();
            if (!page.getId().equals(pageId)) continue;
            return page;
        }
        return null;
    }

    public int getPageCount() {
        return this.pages.size();
    }

    public WizardPage[] getPages() {
        return this.pages.toArray(new WizardPage[this.pages.size()]);
    }

    public WizardPage getPreviousPage(WizardPage page) {
        int index = this.pages.indexOf(page);
        if (index == 0 || index == -1) {
            return null;
        }
        this.logger.debug((Object)"Returning previous page...");
        return (WizardPage)this.pages.get(index - 1);
    }

    public WizardPage getStartingPage() {
        if (this.pages.size() == 0) {
            return null;
        }
        return (WizardPage)this.pages.get(0);
    }

    public boolean needsPreviousAndNextButtons() {
        return this.forcePreviousAndNextButtons || this.pages.size() > 1;
    }

    public void addWizardListener(WizardListener wizardListener) {
        this.listeners.add((Object)wizardListener);
    }

    public void removeWizardListener(WizardListener wizardListener) {
        this.listeners.remove((Object)wizardListener);
    }

    protected void fireFinishedPerformed(boolean result) {
        this.listeners.fire("onPerformFinish", (Object)this, (Object)result);
    }

    protected void fireCancelPerformed(boolean result) {
        this.listeners.fire("onPerformCancel", (Object)this, (Object)result);
    }

    public boolean performFinish() {
        boolean result = this.onFinish();
        this.fireFinishedPerformed(result);
        return result;
    }

    public boolean performCancel() {
        boolean result = this.onCancel();
        this.fireCancelPerformed(result);
        return result;
    }

    protected abstract boolean onFinish();

    protected boolean onCancel() {
        return true;
    }
}

