/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.rules;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.core.closure.Constraint;
import org.springframework.core.style.ToStringCreator;
import org.springframework.rules.PropertyConstraintProvider;
import org.springframework.rules.constraint.And;
import org.springframework.rules.constraint.CompoundConstraint;
import org.springframework.rules.constraint.ConstraintsAccessor;
import org.springframework.rules.constraint.Range;
import org.springframework.rules.constraint.property.CompoundPropertyConstraint;
import org.springframework.rules.constraint.property.PropertyConstraint;
import org.springframework.rules.constraint.property.PropertyValueConstraint;
import org.springframework.util.Assert;
import org.springframework.validation.Errors;
import org.springframework.validation.Validator;

public class Rules
extends ConstraintsAccessor
implements Constraint,
PropertyConstraintProvider,
Validator,
InitializingBean {
    private static final Log logger = LogFactory.getLog((Class)Rules.class);
    private Class domainObjectType;
    private Map propertiesConstraints = new HashMap();
    private List orderedConstraints = new ArrayList();

    public Rules() {
    }

    public Rules(Class domainObjectClass) {
        this.setDomainObjectType(domainObjectClass);
    }

    public Rules(Class domainObjectClass, Map propertiesConstraints) {
        this.setDomainObjectType(domainObjectClass);
        this.setPropertiesConstraints(propertiesConstraints);
    }

    public void setDomainObjectType(Class domainObjectType) {
        Assert.notNull((Object)domainObjectType, (String)"The domainObjectType property is required");
        this.domainObjectType = domainObjectType;
    }

    public Class getDomainObjectType() {
        return this.domainObjectType;
    }

    public void afterPropertiesSet() {
        this.initRules();
    }

    protected void initRules() {
    }

    public void setPropertiesConstraints(Map propertiesConstraints) {
        Iterator i = propertiesConstraints.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry entry = i.next();
            String propertyName = (String)entry.getKey();
            Object value = entry.getValue();
            if (value instanceof List) {
                this.add(propertyName, ((List)value).toArray(new Constraint[0]));
                continue;
            }
            if (value instanceof PropertyConstraint) {
                this.add((PropertyConstraint)value);
                continue;
            }
            if (!(value instanceof Constraint)) continue;
            this.add(propertyName, (Constraint)value);
        }
    }

    private void putPropertyConstraint(PropertyConstraint constraint) {
        And and = new And();
        and.add(constraint);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Putting constraint for property '" + constraint.getPropertyName() + "', constraint -> [" + constraint + "]"));
        }
        CompoundPropertyConstraint compoundConstraint = new CompoundPropertyConstraint(and);
        this.propertiesConstraints.put(constraint.getPropertyName(), compoundConstraint);
        this.orderedConstraints.add(compoundConstraint);
    }

    public PropertyConstraint getPropertyConstraint(String property) {
        if (this.propertiesConstraints.isEmpty()) {
            this.initRules();
        }
        return (PropertyConstraint)this.propertiesConstraints.get(property);
    }

    public Iterator iterator() {
        if (this.orderedConstraints.isEmpty()) {
            this.initRules();
        }
        return this.orderedConstraints.iterator();
    }

    public Rules add(PropertyConstraint constraint) {
        CompoundPropertyConstraint and = (CompoundPropertyConstraint)this.propertiesConstraints.get(constraint.getPropertyName());
        if (and == null) {
            this.putPropertyConstraint(constraint);
        } else {
            and.add(constraint);
        }
        return this;
    }

    public void add(String propertyName, Constraint valueConstraint) {
        this.add(new PropertyValueConstraint(propertyName, valueConstraint));
    }

    public void add(String propertyName, Constraint[] valueConstraints) {
        this.add(new PropertyValueConstraint(propertyName, this.all(valueConstraints)));
    }

    public void addRequired(String propertyName) {
        this.add(propertyName, this.required());
    }

    public void addRequired(String propertyName, Constraint otherConstraints) {
        this.add(propertyName, this.and(this.required(), otherConstraints));
    }

    public void addMaxLength(String propertyName, int maxLength) {
        this.add(propertyName, this.maxLength(maxLength));
    }

    public void addMinLength(String propertyName, int minLength) {
        this.add(propertyName, this.minLength(minLength));
    }

    public void addRange(String propertyName, Range range) {
        this.add(propertyName, range);
    }

    public void add(CompoundConstraint compoundPredicate) {
        this.add(new CompoundPropertyConstraint(compoundPredicate));
    }

    public boolean test(Object bean) {
        Iterator i = this.orderedConstraints.iterator();
        while (i.hasNext()) {
            PropertyConstraint propertyConstraint = (PropertyConstraint)i.next();
            if (propertyConstraint.test(bean)) continue;
            return false;
        }
        return true;
    }

    public boolean supports(Class type) {
        return this.domainObjectType.isAssignableFrom(type);
    }

    public void validate(Object bean, Errors errors) {
    }

    public String toString() {
        return new ToStringCreator((Object)this).append("domainObjectClass", (Object)this.domainObjectType).append("propertyRules", (Object)this.propertiesConstraints).toString();
    }
}

