/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.rules.constraint;

import org.springframework.core.closure.Constraint;
import org.springframework.core.enums.StringCodedLabeledEnum;
import org.springframework.util.StringUtils;

public class Like
implements Constraint {
    public static final LikeType STARTS_WITH = new LikeType("startsWith");
    public static final LikeType ENDS_WITH = new LikeType("endsWith");
    public static final LikeType CONTAINS = new LikeType("contains");
    private LikeType type;
    private String stringToMatch;

    public Like(LikeType type, String likeString) {
        this.type = type;
        this.stringToMatch = likeString;
    }

    public Like(String encodedLikeString) {
        this.type = encodedLikeString.startsWith("%") ? (encodedLikeString.endsWith("%") ? CONTAINS : ENDS_WITH) : (encodedLikeString.endsWith("%") ? STARTS_WITH : CONTAINS);
        this.stringToMatch = StringUtils.deleteAny((String)encodedLikeString, (String)"%");
    }

    public boolean test(Object argument) {
        String value = String.valueOf(argument);
        if (this.type == STARTS_WITH) {
            return value.startsWith(this.stringToMatch);
        }
        if (this.type == ENDS_WITH) {
            return value.endsWith(this.stringToMatch);
        }
        return value.indexOf(this.stringToMatch) != -1;
    }

    public LikeType getType() {
        return this.type;
    }

    public String getString() {
        return this.stringToMatch;
    }

    public static class LikeType
    extends StringCodedLabeledEnum {
        private LikeType(String code) {
            super(code, null);
        }
    }
}

