/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.rules.constraint;

import org.springframework.rules.constraint.And;
import org.springframework.rules.constraint.CompoundConstraint;
import org.springframework.rules.constraint.Operator;
import org.springframework.rules.constraint.Or;
import org.springframework.rules.constraint.XOr;

public abstract class LogicalOperator
extends Operator {
    public static final LogicalOperator AND = new LogicalOperator("and", "&&"){

        public CompoundConstraint createConstraint() {
            return new And();
        }
    };
    public static final LogicalOperator OR = new LogicalOperator("or", "||"){

        public CompoundConstraint createConstraint() {
            return new Or();
        }
    };
    public static final LogicalOperator XOR = new LogicalOperator("xor", "^"){

        public CompoundConstraint createConstraint() {
            return new XOr();
        }
    };

    private LogicalOperator(String code, String symbol) {
        super(code, symbol);
    }

    public CompoundConstraint createConstraint() {
        throw new UnsupportedOperationException();
    }
}

