/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.rules.constraint;

import java.util.Comparator;
import org.springframework.core.closure.Constraint;
import org.springframework.core.style.ToStringCreator;
import org.springframework.rules.constraint.AbstractConstraint;
import org.springframework.rules.constraint.GreaterThan;
import org.springframework.rules.constraint.GreaterThanEqualTo;
import org.springframework.rules.constraint.LessThan;
import org.springframework.rules.constraint.LessThanEqualTo;
import org.springframework.util.Assert;

public final class Range
extends AbstractConstraint {
    private Object min;
    private Object max;
    private boolean inclusive = true;
    private Constraint rangeConstraint;

    public Range(Comparable min, Comparable max) {
        this(min, max, true);
    }

    public Range(Comparable min, Comparable max, boolean inclusive) {
        Constraint maximum;
        Constraint minimum;
        this.commonAssert(min, max);
        this.inclusive = inclusive;
        if (this.inclusive) {
            Assert.isTrue((boolean)LessThanEqualTo.instance().test(min, max), (String)("Minimum " + min + " must be less than or equal to maximum " + max));
            minimum = this.gte(min);
            maximum = this.lte(max);
        } else {
            Assert.isTrue((boolean)LessThan.instance().test(min, max), (String)("Minimum " + min + " must be less than maximum " + max));
            minimum = this.gt(min);
            maximum = this.lt(max);
        }
        this.rangeConstraint = this.and(minimum, maximum);
        this.min = min;
        this.max = max;
    }

    public Range(Object min, Object max, Comparator comparator) {
        this(min, max, comparator, true);
    }

    public Range(Object min, Object max, Comparator comparator, boolean inclusive) {
        Constraint maximum;
        Constraint minimum;
        this.commonAssert(min, max);
        this.inclusive = inclusive;
        if (this.inclusive) {
            Assert.isTrue((boolean)LessThanEqualTo.instance(comparator).test(min, max), (String)("Minimum " + min + " must be less than or equal to maximum " + max));
            minimum = this.bind(GreaterThanEqualTo.instance(comparator), min);
            maximum = this.bind(LessThanEqualTo.instance(comparator), max);
        } else {
            Assert.isTrue((boolean)LessThan.instance(comparator).test(min, max), (String)("Minimum " + min + " must be less than maximum " + max));
            minimum = this.bind(GreaterThan.instance(comparator), min);
            maximum = this.bind(LessThan.instance(comparator), max);
        }
        this.rangeConstraint = this.and(minimum, maximum);
        this.min = min;
        this.max = max;
    }

    private void commonAssert(Object min, Object max) {
        Assert.isTrue((min != null && max != null ? 1 : 0) != 0, (String)"Min and max are required");
        Assert.isTrue((boolean)min.getClass().equals(max.getClass()), (String)"Min and max must be of the same class");
    }

    public Range(int min, int max) {
        this(new Integer(min), new Integer(max));
    }

    public Range(int min, int max, boolean inclusive) {
        this(new Integer(min), new Integer(max), inclusive);
    }

    public Range(float min, float max) {
        this(new Float(min), new Float(max));
    }

    public Range(float min, float max, boolean inclusive) {
        this(new Float(min), new Float(max), inclusive);
    }

    public Range(double min, double max) {
        this(new Double(min), new Double(max));
    }

    public Range(double min, double max, boolean inclusive) {
        this(new Double(min), new Double(max), inclusive);
    }

    public Object getMin() {
        return this.min;
    }

    public Object getMax() {
        return this.max;
    }

    public boolean isInclusive() {
        return this.inclusive;
    }

    public boolean test(Object argument) {
        return this.rangeConstraint.test(argument);
    }

    public String toString() {
        return new ToStringCreator((Object)this).append("rangeConstraint", (Object)this.rangeConstraint).toString();
    }
}

