/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.rules.constraint;

import org.springframework.core.closure.Constraint;
import org.springframework.rules.closure.BinaryConstraint;
import org.springframework.rules.closure.StringLength;
import org.springframework.rules.constraint.AbstractConstraint;
import org.springframework.rules.constraint.Range;
import org.springframework.rules.constraint.RelationalOperator;
import org.springframework.rules.reporting.TypeResolvable;
import org.springframework.util.Assert;

public class StringLengthConstraint
extends AbstractConstraint
implements TypeResolvable {
    private static final long serialVersionUID = 1L;
    private Constraint lengthConstraint;
    private String type;

    public StringLengthConstraint(int length) {
        this(RelationalOperator.LESS_THAN_EQUAL_TO, length);
    }

    public StringLengthConstraint(int length, String type) {
        this(RelationalOperator.LESS_THAN_EQUAL_TO, length, type);
    }

    public StringLengthConstraint(RelationalOperator operator, int length) {
        this(operator, length, null);
    }

    public StringLengthConstraint(RelationalOperator operator, int length, String type) {
        Assert.notNull((Object)((Object)operator), (String)"The relational operator is required");
        Assert.isTrue((length > 0 ? 1 : 0) != 0, (String)"length is required");
        BinaryConstraint comparer = operator.getConstraint();
        Constraint lengthConstraint = this.bind(comparer, length);
        this.lengthConstraint = this.testResultOf(StringLength.instance(), lengthConstraint);
        this.type = type;
    }

    public StringLengthConstraint(int min, int max) {
        this(min, max, null);
    }

    public StringLengthConstraint(int min, int max, String type) {
        Range rangeConstraint = new Range(min, max);
        this.lengthConstraint = this.testResultOf(StringLength.instance(), rangeConstraint);
        this.type = type;
    }

    public boolean test(Object argument) {
        return this.lengthConstraint.test(argument);
    }

    public Constraint getPredicate() {
        return this.lengthConstraint;
    }

    public String toString() {
        return this.lengthConstraint.toString();
    }

    public String getType() {
        return this.type;
    }
}

