/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.rules.constraint.property;

import java.util.Iterator;
import org.springframework.core.closure.Constraint;
import org.springframework.core.closure.support.AbstractConstraint;
import org.springframework.rules.constraint.CompoundConstraint;
import org.springframework.rules.constraint.property.PropertyConstraint;

public class CompoundPropertyConstraint
implements PropertyConstraint {
    private CompoundConstraint compoundConstraint;

    public String getPropertyName() {
        PropertyConstraint e = (PropertyConstraint)this.compoundConstraint.iterator().next();
        return e.getPropertyName();
    }

    public boolean isDependentOn(final String propertyName) {
        return new AbstractConstraint(){

            public boolean test(Object o) {
                return ((PropertyConstraint)o).isDependentOn(propertyName);
            }
        }.anyTrue(this.compoundConstraint.iterator());
    }

    public boolean isCompoundRule() {
        return true;
    }

    public Constraint getPredicate() {
        return this.compoundConstraint;
    }

    public CompoundPropertyConstraint(CompoundConstraint compoundConstraint) {
        this.compoundConstraint = compoundConstraint;
        this.compoundConstraint.validateTypeSafety(PropertyConstraint.class);
    }

    public CompoundPropertyConstraint add(PropertyConstraint constraint) {
        this.compoundConstraint.add(constraint);
        return this;
    }

    public Iterator iterator() {
        return this.compoundConstraint.iterator();
    }

    public boolean test(Object bean) {
        return this.compoundConstraint.test(bean);
    }

    public String toString() {
        return this.compoundConstraint.toString();
    }
}

