/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.rules.constraint.property;

import org.springframework.binding.PropertyAccessStrategy;
import org.springframework.core.closure.Constraint;
import org.springframework.rules.constraint.property.AbstractPropertyConstraint;
import org.springframework.rules.constraint.property.PropertyConstraint;
import org.springframework.util.Assert;

public class PropertyValueConstraint
extends AbstractPropertyConstraint
implements Constraint {
    private Constraint valueConstraint;

    public PropertyValueConstraint(String propertyName, Constraint valueConstraint) {
        super(propertyName);
        Assert.notNull((Object)valueConstraint, (String)"valueConstraint is required");
        Assert.isTrue((!(valueConstraint instanceof PropertyConstraint) ? 1 : 0) != 0, (String)"valueConstraint cannot be a PropertyConstraint - it must be a plain constraint that tests property values!");
        this.valueConstraint = valueConstraint;
    }

    protected boolean test(PropertyAccessStrategy domainObjectAccessStrategy) {
        return this.valueConstraint.test(domainObjectAccessStrategy.getPropertyValue(this.getPropertyName()));
    }

    public Constraint getConstraint() {
        return this.valueConstraint;
    }

    public String toString() {
        return this.valueConstraint.toString();
    }
}

