/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.rules.constraint.property;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.springframework.binding.MutablePropertyAccessStrategy;
import org.springframework.binding.support.BeanPropertyAccessStrategy;
import org.springframework.rules.constraint.AbstractConstraint;
import org.springframework.rules.constraint.property.PropertyConstraint;

public class UniquePropertyValueConstraint
extends AbstractConstraint
implements PropertyConstraint {
    private String propertyName;
    private Map distinctValueTable;

    public UniquePropertyValueConstraint(String propertyName) {
        this.propertyName = propertyName;
    }

    public String getPropertyName() {
        return this.propertyName;
    }

    public boolean isDependentOn(String propertyName) {
        return this.getPropertyName().equals(propertyName);
    }

    public boolean isCompoundRule() {
        return false;
    }

    public boolean test(Object o) {
        Collection domainObjects = (Collection)o;
        this.distinctValueTable = new HashMap((int)((double)domainObjects.size() * 0.75));
        Iterator it = domainObjects.iterator();
        MutablePropertyAccessStrategy accessor = null;
        while (it.hasNext()) {
            Object domainObject = it.next();
            if (accessor == null) {
                accessor = this.createPropertyAccessStrategy(domainObject);
            } else {
                accessor.getDomainObjectHolder().setValue(domainObject);
            }
            Object propertyValue = accessor.getPropertyValue(this.propertyName);
            Integer hashCode = propertyValue == null ? new Integer(0) : new Integer(propertyValue.hashCode());
            if (this.distinctValueTable.containsKey(hashCode)) {
                return false;
            }
            this.distinctValueTable.put(hashCode, propertyValue);
        }
        return true;
    }

    protected MutablePropertyAccessStrategy createPropertyAccessStrategy(Object o) {
        return new BeanPropertyAccessStrategy(o);
    }
}

