/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.rules.factory;

import org.springframework.core.closure.Constraint;
import org.springframework.core.closure.support.AlgorithmsAccessor;
import org.springframework.rules.constraint.property.PropertyConstraint;
import org.springframework.rules.factory.Constraints;
import org.springframework.util.Assert;

public class PropertyConstraints
extends AlgorithmsAccessor {
    private Constraints c = Constraints.instance();
    private String propertyName;

    public PropertyConstraints(String propertyName) {
        this.setPropertyName(propertyName);
    }

    public void setPropertyName(String propertyName) {
        Assert.notNull((Object)propertyName, (String)"The propertyName to create constraints for is required");
        this.propertyName = propertyName;
    }

    public PropertyConstraint all(Constraint[] valueConstraints) {
        return this.c.all(this.propertyName, valueConstraints);
    }

    public PropertyConstraint any(Constraint[] valueConstraints) {
        return this.c.any(this.propertyName, valueConstraints);
    }

    public PropertyConstraint eq(Object value) {
        return this.c.eq(this.propertyName, value);
    }

    public PropertyConstraint lt(Comparable value) {
        return this.c.lt(this.propertyName, value);
    }

    public PropertyConstraint lte(Comparable value) {
        return this.c.lte(this.propertyName, value);
    }

    public PropertyConstraint gt(Comparable value) {
        return this.c.gte(this.propertyName, value);
    }

    public PropertyConstraint gte(Comparable value) {
        return this.c.gte(this.propertyName, value);
    }

    public PropertyConstraint eqProperty(String otherPropertyName) {
        return this.c.eqProperty(this.propertyName, otherPropertyName);
    }

    public PropertyConstraint ltProperty(String otherPropertyName) {
        return this.c.ltProperty(this.propertyName, otherPropertyName);
    }

    public PropertyConstraint lteProperty(String otherPropertyName) {
        return this.c.lteProperty(this.propertyName, otherPropertyName);
    }

    public PropertyConstraint gtProperty(String otherPropertyName) {
        return this.c.gtProperty(this.propertyName, otherPropertyName);
    }

    public PropertyConstraint gteProperty(String otherPropertyName) {
        return this.c.gteProperty(this.propertyName, otherPropertyName);
    }

    public PropertyConstraint inRange(Comparable min, Comparable max) {
        return this.c.inRange(this.propertyName, min, max);
    }

    public PropertyConstraint inRangeProperties(String minProperty, String maxProperty) {
        return this.c.inRangeProperties(this.propertyName, minProperty, maxProperty);
    }
}

