/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.rules.reporting;

import java.util.Locale;
import org.springframework.context.MessageSource;
import org.springframework.core.closure.Constraint;
import org.springframework.richclient.application.ApplicationServicesLocator;
import org.springframework.richclient.core.Severity;
import org.springframework.rules.reporting.MessageTranslator;
import org.springframework.rules.reporting.MessageTranslatorFactory;
import org.springframework.rules.reporting.SummingVisitor;
import org.springframework.rules.reporting.ValidationResults;

public class PropertyResults
implements ValidationResults {
    private String propertyName;
    private Object rejectedValue;
    private Constraint violatedConstraint;
    private Severity severity = Severity.ERROR;
    private MessageTranslatorFactory messageTranslatorFactory;

    public PropertyResults(String propertyName, Object rejectedValue, Constraint violatedConstraint) {
        this.propertyName = propertyName;
        this.rejectedValue = rejectedValue;
        this.violatedConstraint = violatedConstraint;
        this.messageTranslatorFactory = (MessageTranslatorFactory)ApplicationServicesLocator.services().getService(MessageTranslatorFactory.class);
    }

    public String buildMessage(MessageSource messages, Locale locale) {
        return this.buildMessage(locale);
    }

    public String buildMessage(Locale locale) {
        MessageTranslator messageTranslator = this.messageTranslatorFactory.createTranslator(null, locale);
        return messageTranslator.getMessage(this);
    }

    public String getPropertyName() {
        return this.propertyName;
    }

    public Object getRejectedValue() {
        return this.rejectedValue;
    }

    public Constraint getViolatedConstraint() {
        return this.violatedConstraint;
    }

    public int getViolatedCount() {
        return new SummingVisitor(this.getViolatedConstraint()).sum();
    }

    public Severity getSeverity() {
        return this.severity;
    }
}

