/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.rules.support;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.style.ToStringCreator;
import org.springframework.richclient.util.ClassUtils;
import org.springframework.rules.Rules;
import org.springframework.rules.RulesSource;
import org.springframework.rules.constraint.ConstraintsAccessor;
import org.springframework.rules.constraint.property.PropertyConstraint;
import org.springframework.util.Assert;
import org.springframework.util.CachingMapDecorator;
import org.springframework.util.StringUtils;

public class DefaultRulesSource
extends ConstraintsAccessor
implements RulesSource {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private static final String DEFAULT_CONTEXT_ID = "default";
    private Map ruleContexts = new CachingMapDecorator(){

        protected Object create(Object key) {
            return new HashMap();
        }
    };

    public void addRules(Rules rules) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Adding rules -> " + rules));
        }
        this.addRules(DEFAULT_CONTEXT_ID, rules);
    }

    public void addRules(String contextId, Rules rules) {
        Assert.notNull((Object)contextId);
        Assert.notNull((Object)rules);
        Map context = this.getRuleContext(contextId);
        context.put(rules.getDomainObjectType(), rules);
    }

    private Map getRuleContext(String contextId) {
        return (Map)this.ruleContexts.get(contextId);
    }

    public void setRules(List rules) {
        Assert.notNull((Object)rules);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)"Configuring rules in source...");
        }
        this.getRuleContext(DEFAULT_CONTEXT_ID).clear();
        Iterator i = rules.iterator();
        while (i.hasNext()) {
            this.addRules((Rules)i.next());
        }
    }

    public Rules getRules(Class bean) {
        return this.getRules(bean, DEFAULT_CONTEXT_ID);
    }

    public Rules getRules(Class beanType, String contextId) {
        Assert.notNull((Object)beanType);
        if (!StringUtils.hasText((String)contextId)) {
            contextId = DEFAULT_CONTEXT_ID;
        }
        return (Rules)ClassUtils.getValueFromMapForClass((Class)beanType, (Map)this.getRuleContext(contextId));
    }

    public PropertyConstraint getPropertyConstraint(Class bean, String propertyName) {
        return this.getPropertyConstraint(bean, propertyName, DEFAULT_CONTEXT_ID);
    }

    public PropertyConstraint getPropertyConstraint(Class bean, String propertyName, String contextId) {
        Rules rules;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Retrieving rules for bean '" + bean + "', context = " + contextId + ", property '" + propertyName + "'"));
        }
        if ((rules = this.getRules(bean, contextId)) != null) {
            return rules.getPropertyConstraint(propertyName);
        }
        return null;
    }

    public String toString() {
        return new ToStringCreator((Object)this).append("rules", (Object)this.ruleContexts).toString();
    }
}

