/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.binding.support;

import org.springframework.beans.BeansException;
import org.springframework.beans.PropertyAccessor;
import org.springframework.binding.MutablePropertyAccessStrategy;
import org.springframework.binding.support.AbstractPropertyAccessStrategy;
import org.springframework.binding.value.ValueModel;
import org.springframework.binding.value.support.ValueHolder;
import org.springframework.richclient.beans.DefaultMemberPropertyAccessor;

public class ClassPropertyAccessStrategy
extends AbstractPropertyAccessStrategy {
    private final DefaultMemberPropertyAccessor propertyAccessor;

    public ClassPropertyAccessStrategy(Class targetClass) {
        super((ValueModel)new ValueHolder());
        this.propertyAccessor = new DefaultMemberPropertyAccessor(targetClass);
    }

    public ClassPropertyAccessStrategy(Object target) {
        this((ValueModel)new ValueHolder(target));
    }

    public ClassPropertyAccessStrategy(ValueModel domainObjectHolder) {
        this(domainObjectHolder, false);
    }

    public ClassPropertyAccessStrategy(ValueModel domainObjectHolder, boolean fieldAccessEnabled) {
        this(domainObjectHolder, fieldAccessEnabled, true);
    }

    public ClassPropertyAccessStrategy(ValueModel domainObjectHolder, boolean fieldAccessEnabled, boolean strictNullValueHandling) {
        super(domainObjectHolder);
        this.propertyAccessor = new DefaultMemberPropertyAccessor(domainObjectHolder.getValue().getClass(), domainObjectHolder.getValue(), fieldAccessEnabled, strictNullValueHandling);
    }

    public ClassPropertyAccessStrategy(ClassPropertyAccessStrategy parent, String basePropertyPath) {
        super((AbstractPropertyAccessStrategy)parent, basePropertyPath);
        this.propertyAccessor = parent.propertyAccessor;
    }

    protected PropertyAccessor getPropertyAccessor() {
        return this.propertyAccessor;
    }

    public MutablePropertyAccessStrategy getPropertyAccessStrategyForPath(String propertyPath) throws BeansException {
        return new ClassPropertyAccessStrategy(this, this.getFullPropertyPath(propertyPath));
    }

    public MutablePropertyAccessStrategy newPropertyAccessStrategy(ValueModel domainObjectHolder) {
        return new ClassPropertyAccessStrategy(domainObjectHolder);
    }

    protected void domainObjectChanged() {
        this.propertyAccessor.setTarget(this.getDomainObject());
    }
}

