/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.binding.value.support;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.NotSerializableException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Collection;
import org.springframework.binding.value.ValueModel;
import org.springframework.binding.value.support.BufferedCollectionValueModel;

public class DeepCopyBufferedCollectionValueModel
extends BufferedCollectionValueModel {
    public DeepCopyBufferedCollectionValueModel(ValueModel wrappedModel, Class wrappedType) {
        super(wrappedModel, wrappedType);
    }

    protected Collection prepareBackingCollection(Collection col) {
        ArrayList<Object> list = new ArrayList<Object>(col);
        for (int i = 0; i < list.size(); ++i) {
            list.set(i, this.deepCopy(list.get(i)));
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Object deepCopy(Object value) {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream(1024);
            ObjectOutputStream oos = new ObjectOutputStream(baos);
            try {
                oos.writeObject(value);
            }
            catch (NotSerializableException e) {
                Object object = value;
                return object;
            }
            finally {
                oos.close();
            }
            ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
            ObjectInputStream ois = new ObjectInputStream(bais);
            try {
                Object object = ois.readObject();
                return object;
            }
            finally {
                ois.close();
            }
        }
        catch (ClassNotFoundException ex) {
            ex.printStackTrace();
            return null;
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        return null;
    }
}

