/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.richclient.application.mdi;

import java.awt.event.MouseListener;
import java.beans.PropertyVetoException;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JInternalFrame;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.event.InternalFrameAdapter;
import javax.swing.event.InternalFrameEvent;
import org.springframework.richclient.application.ApplicationWindow;
import org.springframework.richclient.application.PageComponent;
import org.springframework.richclient.application.PageDescriptor;
import org.springframework.richclient.application.PageLayoutBuilder;
import org.springframework.richclient.application.ViewDescriptor;
import org.springframework.richclient.application.mdi.DesktopViewDescriptor;
import org.springframework.richclient.application.mdi.ScrollingDesktopPane;
import org.springframework.richclient.application.mdi.contextmenu.DesktopCommandGroupFactory;
import org.springframework.richclient.application.support.AbstractApplicationPage;
import org.springframework.richclient.util.Assert;
import org.springframework.richclient.util.PopupMenuMouseListener;

public class DesktopApplicationPage
extends AbstractApplicationPage
implements PageLayoutBuilder {
    private ScrollingDesktopPane control;
    private JScrollPane scrollPane;
    private Map frames = new HashMap();
    private int dragMode;
    private final DesktopCommandGroupFactory desktopCommandGroupFactory;

    public DesktopApplicationPage(ApplicationWindow window, PageDescriptor pageDescriptor, int dragMode, DesktopCommandGroupFactory desktopCommandGroupFactory) {
        super(window, pageDescriptor);
        this.desktopCommandGroupFactory = desktopCommandGroupFactory;
        Assert.isTrue((dragMode == 0 || dragMode == 1 ? 1 : 0) != 0, (String)"dragMode must be JDesktopPane.LIVE_DRAG_MODE or JDesktopPane.OUTLINE_DRAG_MODE");
        this.dragMode = dragMode;
    }

    protected boolean giveFocusTo(PageComponent pageComponent) {
        if (this.getActiveComponent() == pageComponent) {
            return true;
        }
        JInternalFrame frame = this.getInternalFrame(pageComponent);
        if (frame == null) {
            return false;
        }
        try {
            if (frame.isIcon()) {
                frame.setIcon(false);
            }
            frame.setSelected(true);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
        return pageComponent.getControl().requestFocusInWindow();
    }

    public void addView(String viewDescriptorId) {
        this.showView(viewDescriptorId);
    }

    protected void doAddPageComponent(PageComponent pageComponent) {
        JInternalFrame frame = this.createInternalFrame(pageComponent);
        frame.setVisible(true);
        this.control.add(frame);
    }

    protected JInternalFrame createInternalFrame(final PageComponent pageComponent) {
        JInternalFrame internalFrame = new JInternalFrame(pageComponent.getDisplayName());
        internalFrame.setDefaultCloseOperation(0);
        this.configureFrame(pageComponent, internalFrame);
        this.frames.put(pageComponent, internalFrame);
        internalFrame.addInternalFrameListener(new InternalFrameAdapter(){

            public void internalFrameClosing(InternalFrameEvent e) {
                DesktopApplicationPage.this.close(pageComponent);
            }

            public void internalFrameActivated(InternalFrameEvent e) {
                if (!e.getInternalFrame().isIcon()) {
                    DesktopApplicationPage.this.setActiveComponent(pageComponent);
                }
            }
        });
        internalFrame.getContentPane().add(pageComponent.getControl());
        internalFrame.pack();
        return internalFrame;
    }

    protected void configureFrame(PageComponent component, JInternalFrame frame) {
        ViewDescriptor descriptor;
        if (component.getIcon() != null) {
            frame.setFrameIcon(component.getIcon());
        }
        if ((descriptor = this.getViewDescriptor(component.getId())) instanceof DesktopViewDescriptor) {
            DesktopViewDescriptor desktopViewDescriptor = (DesktopViewDescriptor)descriptor;
            frame.setResizable(desktopViewDescriptor.isResizable());
            frame.setMaximizable(desktopViewDescriptor.isMaximizable());
            frame.setIconifiable(desktopViewDescriptor.isIconifiable());
            frame.setClosable(desktopViewDescriptor.isClosable());
        } else {
            frame.setResizable(true);
            frame.setMaximizable(true);
            frame.setIconifiable(true);
            frame.setClosable(true);
        }
    }

    protected JInternalFrame getInternalFrame(PageComponent pageComponent) {
        return (JInternalFrame)this.frames.get(pageComponent);
    }

    protected void doRemovePageComponent(PageComponent pageComponent) {
        JInternalFrame frame = this.getInternalFrame(pageComponent);
        if (frame != null) {
            frame.dispose();
            this.frames.remove(pageComponent);
        }
    }

    protected JComponent createControl() {
        this.control = new ScrollingDesktopPane();
        this.control.setDragMode(this.dragMode);
        this.scrollPane = new JScrollPane(this.control);
        this.control.addMouseListener((MouseListener)new PopupMenuMouseListener(){

            protected JPopupMenu getPopupMenu() {
                return DesktopApplicationPage.this.desktopCommandGroupFactory.createContextMenuCommandGroup(DesktopApplicationPage.this.getWindow().getCommandManager(), DesktopApplicationPage.this.control).createPopupMenu();
            }
        });
        this.getPageDescriptor().buildInitialLayout((PageLayoutBuilder)this);
        return this.scrollPane;
    }

    protected void updatePageComponentProperties(PageComponent pageComponent) {
        JInternalFrame frame = this.getInternalFrame(pageComponent);
        if (pageComponent.getIcon() != null) {
            frame.setFrameIcon(pageComponent.getIcon());
        }
        frame.setTitle(pageComponent.getDisplayName());
        frame.setToolTipText(pageComponent.getCaption());
    }

    protected void setActiveComponent() {
        JInternalFrame[] frames = this.control.getAllFrames();
        for (int i = 0; i < frames.length; ++i) {
            JInternalFrame frame = frames[i];
            if (frame.isIcon()) continue;
            try {
                frame.setSelected(true);
            }
            catch (PropertyVetoException ignore) {}
            break;
        }
    }
}

