/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.richclient.application.mdi;

import java.awt.Component;
import java.awt.Point;
import java.beans.PropertyVetoException;
import javax.swing.JDesktopPane;
import javax.swing.JInternalFrame;
import org.springframework.richclient.application.mdi.ScrollingDesktopManager;

public class ScrollingDesktopPane
extends JDesktopPane {
    private static int FRAME_OFFSET = 20;
    private ScrollingDesktopManager manager = new ScrollingDesktopManager(this);

    public ScrollingDesktopPane() {
        this.setDesktopManager(this.manager);
    }

    public void setBounds(int x, int y, int w, int h) {
        super.setBounds(x, y, w, h);
        this.checkDesktopSize();
    }

    public Component add(JInternalFrame frame) {
        Point p;
        JInternalFrame[] array = this.getAllFrames();
        Component retval = super.add(frame);
        this.checkDesktopSize();
        if (array.length > 0) {
            p = array[0].getLocation();
            p.x += FRAME_OFFSET;
            p.y += FRAME_OFFSET;
        } else {
            p = new Point(0, 0);
        }
        frame.setLocation(p.x, p.y);
        this.moveToFront(frame);
        frame.setVisible(true);
        try {
            frame.setSelected(true);
        }
        catch (PropertyVetoException e) {
            frame.toBack();
        }
        return retval;
    }

    public void remove(Component c) {
        super.remove(c);
        this.checkDesktopSize();
    }

    private void checkDesktopSize() {
        if (this.getParent() != null && this.isVisible()) {
            this.manager.resizeDesktop();
        }
    }
}

