/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.richclient.application.mdi.contextmenu;

import javax.swing.JDesktopPane;
import javax.swing.JInternalFrame;
import org.springframework.richclient.application.mdi.contextmenu.CascadeCommand;
import org.springframework.richclient.application.mdi.contextmenu.DesktopCommandGroupFactory;
import org.springframework.richclient.application.mdi.contextmenu.MinimizeAllCommand;
import org.springframework.richclient.application.mdi.contextmenu.ShowFrameCommand;
import org.springframework.richclient.application.mdi.contextmenu.TileCommand;
import org.springframework.richclient.command.AbstractCommand;
import org.springframework.richclient.command.CommandGroup;
import org.springframework.richclient.command.CommandManager;

public class DefaultDesktopCommandGroupFactory
implements DesktopCommandGroupFactory {
    private boolean cascadeResizesFrames = false;
    private int cascadeOffset = 20;

    public CommandGroup createWindowMenuCommandGroup(CommandManager commandManager, JDesktopPane desktopPane) {
        return null;
    }

    public CommandGroup createContextMenuCommandGroup(CommandManager commandManager, JDesktopPane desktop) {
        CommandGroup commandGroup = new CommandGroup();
        TileCommand tileCommand = new TileCommand(desktop);
        CascadeCommand cascadeCommand = new CascadeCommand(desktop, this.cascadeOffset, this.cascadeResizesFrames);
        MinimizeAllCommand minimizeAllCommand = new MinimizeAllCommand(desktop);
        commandManager.configure((AbstractCommand)tileCommand);
        commandManager.configure((AbstractCommand)cascadeCommand);
        commandManager.configure((AbstractCommand)minimizeAllCommand);
        commandGroup.add((AbstractCommand)tileCommand);
        commandGroup.add((AbstractCommand)cascadeCommand);
        commandGroup.add((AbstractCommand)minimizeAllCommand);
        if (desktop.getAllFrames().length > 0) {
            commandGroup.addSeparator();
            for (int i = 0; i < desktop.getAllFrames().length; ++i) {
                JInternalFrame frame = desktop.getAllFrames()[i];
                ShowFrameCommand showFrameCommand = new ShowFrameCommand(frame);
                showFrameCommand.setIcon(frame.getFrameIcon());
                showFrameCommand.setCaption("" + frame.getTitle());
                String label = i + " " + frame.getTitle();
                if (i < 10) {
                    label = "&" + label;
                }
                showFrameCommand.setLabel(label);
                commandGroup.add((AbstractCommand)showFrameCommand);
            }
        }
        return commandGroup;
    }

    public void setCascadeResizesFrames(boolean resizeFrames) {
        this.cascadeResizesFrames = resizeFrames;
    }

    public void setCascadeOffset(int offset) {
        this.cascadeOffset = offset;
    }
}

