/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.richclient.beans;

import java.beans.PropertyEditor;
import java.io.ByteArrayOutputStream;
import java.io.PrintWriter;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.springframework.beans.AbstractPropertyAccessor;
import org.springframework.beans.BeansException;
import org.springframework.beans.InvalidPropertyException;
import org.springframework.beans.NotReadablePropertyException;
import org.springframework.core.JdkVersion;
import org.springframework.core.MethodParameter;
import org.springframework.richclient.beans.PropertyAccessorUtils;
import org.springframework.richclient.core.GenericCollectionTypeResolver;
import org.springframework.util.Assert;

public abstract class AbstractMemberPropertyAccessor
extends AbstractPropertyAccessor {
    private Class targetClass;
    private final boolean fieldAccessEnabled;
    private final Map readAccessors = new HashMap();
    private final Map writeAccessors = new HashMap();

    protected AbstractMemberPropertyAccessor(Class targetClass, boolean fieldAccessEnabled) {
        this.fieldAccessEnabled = fieldAccessEnabled;
        this.registerDefaultEditors();
        this.setTargetClass(targetClass);
    }

    protected void setTargetClass(Class targetClass) {
        this.targetClass = targetClass;
        this.readAccessors.clear();
        this.writeAccessors.clear();
        this.introspectMethods(targetClass, new HashSet());
        if (this.isFieldAccessEnabled()) {
            this.introspectFields(targetClass, new HashSet());
        }
    }

    private void introspectFields(Class type, Set introspectedClasses) {
        if (type == null || Object.class.equals(type) || type.isInterface() || introspectedClasses.contains(type)) {
            return;
        }
        introspectedClasses.add(type);
        this.introspectFields(type.getSuperclass(), introspectedClasses);
        Field[] fields = type.getDeclaredFields();
        for (int i = 0; i < fields.length; ++i) {
            if (Modifier.isStatic(fields[i].getModifiers())) continue;
            this.readAccessors.put(fields[i].getName(), fields[i]);
            if (Modifier.isFinal(fields[i].getModifiers())) continue;
            this.writeAccessors.put(fields[i].getName(), fields[i]);
        }
    }

    private void introspectMethods(Class type, Set introspectedClasses) {
        if (type == null || Object.class.equals(type) || introspectedClasses.contains(type)) {
            return;
        }
        introspectedClasses.add(type);
        Class<?>[] interfaces = type.getInterfaces();
        for (int i = 0; i < interfaces.length; ++i) {
            this.introspectMethods(interfaces[i], introspectedClasses);
        }
        this.introspectMethods(type.getSuperclass(), introspectedClasses);
        Method[] methods = type.getDeclaredMethods();
        for (int i = 0; i < methods.length; ++i) {
            String methodName = methods[i].getName();
            if (methodName.startsWith("get") && methods[i].getParameterTypes().length == 0) {
                this.readAccessors.put(this.getPropertyName(methodName, 3), methods[i]);
                continue;
            }
            if (methodName.startsWith("is") && methods[i].getParameterTypes().length == 0) {
                this.readAccessors.put(this.getPropertyName(methodName, 2), methods[i]);
                continue;
            }
            if (!methodName.startsWith("set") || methods[i].getParameterTypes().length != 1) continue;
            this.writeAccessors.put(this.getPropertyName(methodName, 3), methods[i]);
        }
    }

    public boolean isFieldAccessEnabled() {
        return this.fieldAccessEnabled;
    }

    public Class getTargetClass() {
        return this.targetClass;
    }

    protected Member getReadPropertyAccessor(String propertyName) {
        return (Member)this.readAccessors.get(propertyName);
    }

    protected Member getWritePropertyAccessor(String propertyName) {
        return (Member)this.writeAccessors.get(propertyName);
    }

    protected Member getPropertyAccessor(String propertyName) {
        if (this.readAccessors.containsKey(propertyName)) {
            return (Member)this.readAccessors.get(propertyName);
        }
        return (Member)this.writeAccessors.get(propertyName);
    }

    public boolean isReadableProperty(String propertyName) {
        if (PropertyAccessorUtils.isIndexedProperty(propertyName)) {
            String rootProperty = this.getRootPropertyName(propertyName);
            String parentProperty = this.getParentPropertyName(propertyName);
            return this.isReadableProperty(rootProperty) && this.checkKeyTypes(propertyName) && (!this.getPropertyType(parentProperty).isArray() || this.checkSize(propertyName) || this.isWritableProperty(parentProperty)) && (this.isReadableProperty(parentProperty) && this.getPropertyValue(parentProperty) != null || this.isWritableProperty(parentProperty));
        }
        return this.readAccessors.containsKey(propertyName);
    }

    public boolean isWritableProperty(String propertyName) {
        if (PropertyAccessorUtils.isIndexedProperty(propertyName)) {
            return this.isReadableProperty(propertyName);
        }
        return this.writeAccessors.containsKey(propertyName);
    }

    public Class getPropertyType(String propertyName) {
        if (PropertyAccessorUtils.isIndexedProperty(propertyName)) {
            int nestingLevel = PropertyAccessorUtils.getNestingLevel(propertyName);
            if (JdkVersion.isAtLeastJava15()) {
                Member accessor = this.getPropertyAccessor(this.getRootPropertyName(propertyName));
                if (accessor instanceof Field) {
                    return GenericCollectionTypeResolver.getIndexedValueFieldType((Field)accessor, nestingLevel);
                }
                Method accessorMethod = (Method)accessor;
                MethodParameter parameter = new MethodParameter(accessorMethod, accessorMethod.getParameterTypes().length - 1);
                return GenericCollectionTypeResolver.getIndexedValueMethodType(parameter, nestingLevel);
            }
            Class<?> type = this.getPropertyType(this.getRootPropertyName(propertyName));
            for (int i = 0; i < nestingLevel; ++i) {
                if (!type.isArray()) {
                    return Object.class;
                }
                type = type.getComponentType();
            }
            return type;
        }
        Member readAccessor = (Member)this.readAccessors.get(propertyName);
        if (readAccessor instanceof Field) {
            return ((Field)readAccessor).getType();
        }
        if (readAccessor instanceof Method) {
            return ((Method)readAccessor).getReturnType();
        }
        Member writeAccessor = (Member)this.writeAccessors.get(propertyName);
        if (writeAccessor instanceof Field) {
            return ((Field)writeAccessor).getType();
        }
        if (writeAccessor instanceof Method) {
            return ((Method)writeAccessor).getParameterTypes()[0];
        }
        return null;
    }

    public Class getIndexedPropertyKeyType(String propertyName) {
        Class type;
        if (!PropertyAccessorUtils.isIndexedProperty(propertyName)) {
            throw new IllegalArgumentException("'" + propertyName + "' is no indexed property");
        }
        if (!Map.class.isAssignableFrom(type = this.getPropertyType(this.getParentPropertyName(propertyName)))) {
            return Integer.class;
        }
        if (JdkVersion.isAtLeastJava15()) {
            int nestingLevel = PropertyAccessorUtils.getNestingLevel(propertyName) - 1;
            Member accessor = this.getPropertyAccessor(this.getRootPropertyName(propertyName));
            if (accessor instanceof Field) {
                return GenericCollectionTypeResolver.getMapKeyFieldType((Field)accessor, nestingLevel);
            }
            if (accessor instanceof Method) {
                MethodParameter parameter = new MethodParameter((Method)accessor, ((Method)accessor).getParameterTypes().length - 1, nestingLevel);
                return GenericCollectionTypeResolver.getMapKeyParameterType(parameter);
            }
            throw new InvalidPropertyException(this.getTargetClass(), propertyName, "property not accessable");
        }
        return String.class;
    }

    public Object getPropertyValue(String propertyName) throws BeansException {
        if (PropertyAccessorUtils.isIndexedProperty(propertyName)) {
            return this.getIndexedPropertyValue(propertyName);
        }
        return this.getSimplePropertyValue(propertyName);
    }

    public void setPropertyValue(String propertyName, Object value) throws BeansException {
        if (PropertyAccessorUtils.isIndexedProperty(propertyName)) {
            this.setIndexedPropertyValue(propertyName, value);
        } else {
            this.setSimplePropertyValue(propertyName, value);
        }
    }

    protected abstract Object getIndexedPropertyValue(String var1);

    protected abstract Object getSimplePropertyValue(String var1);

    protected abstract void setIndexedPropertyValue(String var1, Object var2);

    protected abstract void setSimplePropertyValue(String var1, Object var2);

    protected String getPropertyName(String methodName, int prefixLength) {
        return Character.toLowerCase(methodName.charAt(prefixLength)) + methodName.substring(prefixLength + 1);
    }

    protected String getRootPropertyName(String propertyName) {
        int location = propertyName.indexOf("[");
        return location == -1 ? propertyName : propertyName.substring(0, location);
    }

    protected String getParentPropertyName(String propertyName) {
        if (!PropertyAccessorUtils.isIndexedProperty(propertyName)) {
            return "";
        }
        return propertyName.substring(0, propertyName.lastIndexOf(91));
    }

    protected boolean checkKeyTypes(String propertyName) {
        try {
            this.getIndices(propertyName);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    protected Object[] getIndices(String propertyName) {
        String rootPropertyName;
        int location = propertyName.indexOf("[");
        if (location == -1) {
            return new Object[0];
        }
        String[] indexStrings = this.split(propertyName.substring(location));
        Object[] indices = new Object[indexStrings.length];
        String indexedPropertyName = rootPropertyName = this.getRootPropertyName(propertyName);
        for (int i = 0; i < indices.length; ++i) {
            indexedPropertyName = indexedPropertyName + '[' + indexStrings[i] + ']';
            Class keyType = this.getIndexedPropertyKeyType(indexedPropertyName);
            indices[i] = this.convert(keyType, indexStrings[i]);
        }
        return indices;
    }

    private Object convert(Class targetClass, String value) {
        if (Object.class.equals(targetClass) || String.class.equals(targetClass)) {
            return value;
        }
        PropertyEditor editor = this.getDefaultEditor(targetClass);
        editor.setAsText(value);
        return editor.getValue();
    }

    private String[] split(String indices) {
        Assert.isTrue((boolean)indices.startsWith("["));
        Assert.isTrue((boolean)indices.endsWith("]"));
        ArrayList<String> result = new ArrayList<String>();
        int fromIndex = 1;
        int toIndex = -1;
        while ((toIndex = indices.indexOf("][", fromIndex)) != -1) {
            result.add(indices.substring(fromIndex, toIndex));
            fromIndex = toIndex + 2;
        }
        result.add(indices.substring(fromIndex, indices.length() - 1));
        return result.toArray(new String[result.size()]);
    }

    private boolean checkSize(String propertyName) {
        String parentPropertyName = this.getParentPropertyName(propertyName);
        if (!this.getPropertyType(parentPropertyName).isArray()) {
            try {
                return this.getPropertyValue(parentPropertyName) != null;
            }
            catch (NotReadablePropertyException e) {
                return false;
            }
        }
        int from = propertyName.lastIndexOf(91) + 1;
        int to = propertyName.length() - 1;
        int index = Integer.parseInt(propertyName.substring(from, to));
        try {
            Object parentProperty = this.getPropertyValue(parentPropertyName);
            return parentProperty != null && Array.getLength(parentProperty) > index;
        }
        catch (NotReadablePropertyException e) {
            return false;
        }
    }

    protected NotReadablePropertyException createNotReadablePropertyException(String propertyName, Exception e) {
        if (JdkVersion.isAtLeastJava14()) {
            NotReadablePropertyException beanException = new NotReadablePropertyException(this.getTargetClass(), propertyName);
            beanException.initCause((Throwable)e);
            return beanException;
        }
        ByteArrayOutputStream stackTrace = new ByteArrayOutputStream();
        PrintWriter stackTraceWriter = new PrintWriter(stackTrace);
        e.printStackTrace(stackTraceWriter);
        stackTraceWriter.close();
        return new NotReadablePropertyException(this.getTargetClass(), propertyName, new String(stackTrace.toByteArray()));
    }

    protected Object setAssemblageValue(Class assemblageType, Object assemblage, Object index, Object value) {
        if (assemblageType.isArray()) {
            int i = (Integer)index;
            if (Array.getLength(assemblage) <= i) {
                Object newAssemblage = Array.newInstance(assemblageType.getComponentType(), i + 1);
                System.arraycopy(assemblage, 0, newAssemblage, 0, Array.getLength(assemblage));
                assemblage = newAssemblage;
            }
            Array.set(assemblage, i, value);
        } else if (List.class.isAssignableFrom(assemblageType)) {
            int i = (Integer)index;
            List list = (List)assemblage;
            if (list.size() > i) {
                list.set(i, value);
            } else {
                while (list.size() < i) {
                    list.add(null);
                }
                list.add(value);
            }
        } else if (Map.class.isAssignableFrom(assemblageType)) {
            ((Map)assemblage).put(index, value);
        } else if (assemblage instanceof Collection) {
            ((Collection)assemblage).add(value);
        } else {
            throw new IllegalArgumentException("assemblage must be of type array, collection or map.");
        }
        return assemblage;
    }
}

