/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.richclient.beans;

import org.springframework.beans.NullValueInNestedPathException;
import org.springframework.beans.PropertyAccessor;
import org.springframework.richclient.beans.AbstractMemberPropertyAccessor;
import org.springframework.richclient.beans.PropertyAccessorUtils;
import org.springframework.util.CachingMapDecorator;

public abstract class AbstractNestedMemberPropertyAccessor
extends AbstractMemberPropertyAccessor {
    private AbstractNestedMemberPropertyAccessor parentPropertyAccessor;
    private String basePropertyName;
    private final ChildPropertyAccessorCache childPropertyAccessors = new ChildPropertyAccessorCache();
    private final boolean strictNullHandlingEnabled;

    protected AbstractNestedMemberPropertyAccessor(Class targetClass, boolean fieldAccessEnabled, boolean strictNullHandlingEnabled) {
        super(targetClass, fieldAccessEnabled);
        this.strictNullHandlingEnabled = strictNullHandlingEnabled;
    }

    public AbstractNestedMemberPropertyAccessor(AbstractNestedMemberPropertyAccessor parent, String baseProperty) {
        super(parent.getPropertyType(baseProperty), parent.isFieldAccessEnabled());
        this.parentPropertyAccessor = parent;
        this.basePropertyName = baseProperty;
        this.strictNullHandlingEnabled = parent.strictNullHandlingEnabled;
    }

    public boolean isStrictNullHandlingEnabled() {
        return this.strictNullHandlingEnabled;
    }

    protected AbstractNestedMemberPropertyAccessor getParentPropertyAccessor() {
        return this.parentPropertyAccessor;
    }

    protected String getBasePropertyName() {
        return this.basePropertyName;
    }

    public Object getTarget() {
        if (this.parentPropertyAccessor != null && this.basePropertyName != null) {
            return this.parentPropertyAccessor.getPropertyValue(this.basePropertyName);
        }
        return null;
    }

    public Class getTargetClass() {
        if (this.parentPropertyAccessor != null) {
            return this.parentPropertyAccessor.getPropertyType(this.basePropertyName);
        }
        return super.getTargetClass();
    }

    public boolean isReadableProperty(String propertyPath) {
        if (PropertyAccessorUtils.isNestedProperty(propertyPath)) {
            String baseProperty = this.getBasePropertyName(propertyPath);
            String childPropertyPath = this.getChildPropertyPath(propertyPath);
            if (!super.isReadableProperty(baseProperty)) {
                return false;
            }
            return ((PropertyAccessor)this.childPropertyAccessors.get(baseProperty)).isReadableProperty(childPropertyPath);
        }
        return super.isReadableProperty(propertyPath);
    }

    public boolean isWritableProperty(String propertyPath) {
        if (PropertyAccessorUtils.isNestedProperty(propertyPath)) {
            String baseProperty = this.getBasePropertyName(propertyPath);
            String childPropertyPath = this.getChildPropertyPath(propertyPath);
            return super.isReadableProperty(baseProperty) && ((PropertyAccessor)this.childPropertyAccessors.get(baseProperty)).isWritableProperty(childPropertyPath);
        }
        return super.isWritableProperty(propertyPath);
    }

    public Class getPropertyType(String propertyPath) {
        if (PropertyAccessorUtils.isNestedProperty(propertyPath)) {
            String baseProperty = this.getBasePropertyName(propertyPath);
            String childPropertyPath = this.getChildPropertyPath(propertyPath);
            return ((PropertyAccessor)this.childPropertyAccessors.get(baseProperty)).getPropertyType(childPropertyPath);
        }
        return super.getPropertyType(propertyPath);
    }

    public Object getPropertyValue(String propertyPath) {
        if (PropertyAccessorUtils.isNestedProperty(propertyPath)) {
            String baseProperty = this.getBasePropertyName(propertyPath);
            String childPropertyPath = this.getChildPropertyPath(propertyPath);
            return ((PropertyAccessor)this.childPropertyAccessors.get(baseProperty)).getPropertyValue(childPropertyPath);
        }
        if (this.isStrictNullHandlingEnabled() && this.getTarget() == null) {
            throw new NullValueInNestedPathException(this.getTargetClass(), propertyPath);
        }
        return super.getPropertyValue(propertyPath);
    }

    public void setPropertyValue(String propertyPath, Object value) {
        if (PropertyAccessorUtils.isNestedProperty(propertyPath)) {
            String baseProperty = this.getBasePropertyName(propertyPath);
            String childPropertyPath = this.getChildPropertyPath(propertyPath);
            ((PropertyAccessor)this.childPropertyAccessors.get(baseProperty)).setPropertyValue(childPropertyPath, value);
        } else {
            if (this.isStrictNullHandlingEnabled() && this.getTarget() == null) {
                throw new NullValueInNestedPathException(this.getTargetClass(), propertyPath);
            }
            super.setPropertyValue(propertyPath, value);
        }
    }

    protected String getBasePropertyName(String propertyPath) {
        int index = PropertyAccessorUtils.getFirstNestedPropertySeparatorIndex((String)propertyPath);
        return index == -1 ? propertyPath : propertyPath.substring(0, index);
    }

    protected String getChildPropertyPath(String propertyPath) {
        int index = PropertyAccessorUtils.getFirstNestedPropertySeparatorIndex((String)propertyPath);
        if (index == -1) {
            return "";
        }
        return propertyPath.substring(index + 1);
    }

    protected PropertyAccessor getChildPropertyAccessor(String propertyName) {
        return (PropertyAccessor)this.childPropertyAccessors.get(propertyName);
    }

    protected abstract AbstractNestedMemberPropertyAccessor createChildPropertyAccessor(String var1);

    protected void clearChildPropertyAccessorCache() {
        this.childPropertyAccessors.clear();
    }

    private class ChildPropertyAccessorCache
    extends CachingMapDecorator {
        private ChildPropertyAccessorCache() {
        }

        protected Object create(Object propertyName) {
            return AbstractNestedMemberPropertyAccessor.this.createChildPropertyAccessor((String)propertyName);
        }
    }
}

