/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.richclient.beans;

import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.springframework.beans.BeansException;
import org.springframework.beans.InvalidPropertyException;
import org.springframework.beans.NotReadablePropertyException;
import org.springframework.beans.NotWritablePropertyException;
import org.springframework.beans.NullValueInNestedPathException;
import org.springframework.beans.TypeMismatchException;
import org.springframework.core.JdkVersion;
import org.springframework.core.MethodParameter;
import org.springframework.richclient.beans.AbstractNestedMemberPropertyAccessor;
import org.springframework.richclient.util.ReflectionUtils;

public class DefaultMemberPropertyAccessor
extends AbstractNestedMemberPropertyAccessor {
    private Object target;
    private boolean fixedTargetClass;

    public DefaultMemberPropertyAccessor(Class targetClass) {
        this(targetClass, null, false, false);
    }

    public DefaultMemberPropertyAccessor(Object target) {
        this(target, false, true);
    }

    public DefaultMemberPropertyAccessor(Object target, boolean fieldAccessEnabled, boolean strictNullHandlingEnabled) {
        super(target.getClass(), fieldAccessEnabled, strictNullHandlingEnabled);
        this.setTarget(target);
    }

    public DefaultMemberPropertyAccessor(Class targetClass, Object target, boolean fieldAccessEnabled, boolean strictNullHandlingEnabled) {
        super(targetClass, fieldAccessEnabled, strictNullHandlingEnabled);
        this.fixedTargetClass = true;
        this.setTarget(target);
    }

    protected DefaultMemberPropertyAccessor(AbstractNestedMemberPropertyAccessor parent, String baseProperty) {
        super(parent, baseProperty);
    }

    public Object getTarget() {
        if (this.target != null) {
            return this.target;
        }
        return super.getTarget();
    }

    public void setTarget(Object target) {
        if (this.getParentPropertyAccessor() != null) {
            throw new IllegalStateException("explicite setting of target is not allowed for child property accessors");
        }
        this.target = target;
        if (!this.fixedTargetClass && target != null && target.getClass() != this.getTargetClass()) {
            this.setTargetClass(target.getClass());
            this.clearChildPropertyAccessorCache();
        }
    }

    public Object getIndexedPropertyValue(String propertyName) throws BeansException {
        Object[] indices;
        if (this.getPropertyType(propertyName) == null) {
            throw new NotReadablePropertyException(this.getTargetClass(), propertyName, "property type could not be determined");
        }
        String rootPropertyName = this.getRootPropertyName(propertyName);
        Member readAccessor = this.getReadPropertyAccessor(rootPropertyName);
        if (readAccessor == null) {
            throw new NotReadablePropertyException(this.getTargetClass(), propertyName, "Neither non-static field nor get-method exists for indexed property");
        }
        Object rootProperty = this.getPropertyValue(rootPropertyName);
        if (rootProperty == null) {
            if (this.isStrictNullHandlingEnabled()) {
                throw new NullValueInNestedPathException(this.getTargetClass(), propertyName);
            }
            if (this.isWritableProperty(rootPropertyName)) {
                return null;
            }
            throw new NotReadablePropertyException(this.getTargetClass(), propertyName);
        }
        try {
            indices = this.getIndices(propertyName);
        }
        catch (Exception e) {
            throw this.createNotReadablePropertyException(propertyName, e);
        }
        return this.getPropertyValue(rootProperty, indices);
    }

    public Object getSimplePropertyValue(String propertyName) throws BeansException {
        Member readAccessor = this.getReadPropertyAccessor(propertyName);
        if (readAccessor == null) {
            throw new NotReadablePropertyException(this.getTargetClass(), propertyName, "Neither non-static field nor get-method does exist");
        }
        Object target = this.getTarget();
        if (target == null) {
            return null;
        }
        try {
            ReflectionUtils.makeAccessible(readAccessor);
            if (readAccessor instanceof Field) {
                return ((Field)readAccessor).get(target);
            }
            return ((Method)readAccessor).invoke(target, null);
        }
        catch (IllegalAccessException e) {
            throw new InvalidPropertyException(this.getTargetClass(), propertyName, "Property is not accessible", (Throwable)e);
        }
        catch (InvocationTargetException e) {
            ReflectionUtils.handleInvocationTargetException((InvocationTargetException)e);
            throw new IllegalStateException("An unexpected state occured during getSimplePropertyValue(String). This may be a bug.");
        }
    }

    private Object getPropertyValue(Object assemblage, Object[] indices) {
        return this.getPropertyValue(assemblage, indices, 0);
    }

    private Object getPropertyValue(Object assemblage, Object[] indices, int parameterIndex) {
        if (assemblage == null) {
            if (this.isStrictNullHandlingEnabled()) {
                throw new NullValueInNestedPathException(this.getTargetClass(), "");
            }
            return null;
        }
        Object value = null;
        if (assemblage.getClass().isArray()) {
            value = this.getArrayValue(assemblage, (Integer)indices[parameterIndex]);
        } else if (assemblage instanceof List) {
            value = this.getListValue((List)assemblage, (Integer)indices[parameterIndex]);
        } else if (assemblage instanceof Map) {
            value = this.getMapValue((Map)assemblage, indices[parameterIndex]);
        } else if (assemblage instanceof Collection) {
            value = this.getCollectionValue((Collection)assemblage, (Integer)indices[parameterIndex]);
        } else {
            throw new IllegalStateException("getPropertyValue(Object, Object[], int) called with neither array nor collection nor map");
        }
        if (parameterIndex == indices.length - 1) {
            return value;
        }
        if (value == null) {
            if (this.isStrictNullHandlingEnabled()) {
                throw new InvalidPropertyException(this.getTargetClass(), "", "");
            }
            return null;
        }
        return this.getPropertyValue(value, indices, parameterIndex + 1);
    }

    private Object getArrayValue(Object array, Integer index) {
        if (Array.getLength(array) > index) {
            return Array.get(array, index);
        }
        if (this.isStrictNullHandlingEnabled()) {
            throw new InvalidPropertyException(this.getTargetClass(), "", "");
        }
        return null;
    }

    private Object getListValue(List list, Integer index) {
        if (list.size() > index) {
            return list.get(index);
        }
        if (this.isStrictNullHandlingEnabled()) {
            throw new InvalidPropertyException(this.getTargetClass(), "", "");
        }
        return null;
    }

    private Object getMapValue(Map map, Object key) {
        if (map.containsKey(key)) {
            return map.get(key);
        }
        if (!JdkVersion.isAtLeastJava15()) {
            Iterator i = map.entrySet().iterator();
            while (i.hasNext()) {
                Map.Entry entry = i.next();
                if (entry.getKey() != key && (entry.getKey() == null || key == null || !entry.getKey().toString().equals(key.toString()))) continue;
                return entry.getValue();
            }
        }
        return null;
    }

    private Object getCollectionValue(Collection collection, Integer index) {
        if (collection.size() > index) {
            Iterator iterator = collection.iterator();
            for (int i = 0; i < index; ++i) {
                iterator.next();
            }
            return iterator.next();
        }
        if (this.isStrictNullHandlingEnabled()) {
            throw new InvalidPropertyException(this.getTargetClass(), "", "");
        }
        return null;
    }

    public void setIndexedPropertyValue(String propertyName, Object value) throws BeansException {
        Object[] indices;
        Object parentValue;
        String parentPropertyName = this.getParentPropertyName(propertyName);
        try {
            parentValue = this.getPropertyValue(parentPropertyName);
        }
        catch (NotReadablePropertyException e) {
            throw new NotWritablePropertyException(this.getTargetClass(), propertyName, "parent property is not readable", (Throwable)e);
        }
        if (parentValue == null) {
            if (this.isWritableProperty(parentPropertyName)) {
                throw new NullValueInNestedPathException(this.getTargetClass(), propertyName);
            }
            throw new NotWritablePropertyException(this.getTargetClass(), propertyName);
        }
        try {
            indices = this.getIndices(propertyName);
        }
        catch (Exception e) {
            throw new NotWritablePropertyException(this.getTargetClass(), propertyName, "wrong index type", (Throwable)e);
        }
        Object index = indices[indices.length - 1];
        Object newParentValue = this.setAssemblageValue(this.getPropertyType(parentPropertyName), parentValue, index, value);
        if (newParentValue != parentValue) {
            this.setPropertyValue(parentPropertyName, newParentValue);
        }
    }

    public void setSimplePropertyValue(String propertyName, Object value) throws BeansException {
        Member writeAccessor = this.getWritePropertyAccessor(propertyName);
        if (writeAccessor == null) {
            throw new NotWritablePropertyException(this.getTargetClass(), propertyName, "Neither non-static, non-final field nor set-method does exist");
        }
        Object target = this.getTarget();
        if (target == null) {
            throw new NullValueInNestedPathException(this.getTargetClass(), propertyName);
        }
        try {
            ReflectionUtils.makeAccessible(writeAccessor);
            if (writeAccessor instanceof Field) {
                ((Field)writeAccessor).set(target, value);
            } else {
                ((Method)writeAccessor).invoke(target, value);
            }
        }
        catch (IllegalAccessException e) {
            throw new InvalidPropertyException(this.getTargetClass(), propertyName, "Property is not accessible", (Throwable)e);
        }
        catch (InvocationTargetException e) {
            ReflectionUtils.handleInvocationTargetException((InvocationTargetException)e);
            throw new IllegalStateException("An unexpected state occured during setPropertyValue(String, Object). This may be a bug.");
        }
    }

    protected AbstractNestedMemberPropertyAccessor createChildPropertyAccessor(String propertyName) {
        return new DefaultMemberPropertyAccessor(this, propertyName);
    }

    public Object convertIfNecessary(Object value, Class requiredType, MethodParameter methodParam) throws TypeMismatchException {
        return null;
    }
}

