/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.richclient.beans;

public abstract class PropertyAccessorUtils
extends org.springframework.beans.PropertyAccessorUtils {
    public static String getParentPropertyPath(String propertyPath) {
        int propertySeparatorIndex = PropertyAccessorUtils.getLastNestedPropertySeparatorIndex((String)propertyPath);
        return propertySeparatorIndex == -1 ? "" : propertyPath.substring(0, propertySeparatorIndex);
    }

    public static String getPropertyName(String propertyPath) {
        int propertySeparatorIndex = PropertyAccessorUtils.getLastNestedPropertySeparatorIndex((String)propertyPath);
        return propertySeparatorIndex == -1 ? propertyPath : propertyPath.substring(propertySeparatorIndex + 1);
    }

    public static boolean isIndexedProperty(String propertyName) {
        return propertyName.indexOf(91) != -1 && propertyName.charAt(propertyName.length() - 1) == ']';
    }

    public static boolean isNestedProperty(String propertyPath) {
        return PropertyAccessorUtils.getFirstNestedPropertySeparatorIndex((String)propertyPath) != -1;
    }

    public static int getNestingLevel(String propertyName) {
        propertyName = PropertyAccessorUtils.getPropertyName(propertyName);
        int nestingLevel = 0;
        boolean inKey = false;
        for (int i = 0; i < propertyName.length(); ++i) {
            switch (propertyName.charAt(i)) {
                case '[': {
                    if (!inKey) {
                        ++nestingLevel;
                    }
                }
                case ']': {
                    inKey = !inKey;
                }
            }
        }
        return nestingLevel;
    }
}

