/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.richclient.context.support;

import java.util.Locale;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.context.MessageSource;
import org.springframework.context.NoSuchMessageException;
import org.springframework.richclient.util.Assert;

public abstract class AbstractConfigurableBeanPostProcessor
implements BeanPostProcessor {
    private static final Log logger = LogFactory.getLog((Class)AbstractConfigurableBeanPostProcessor.class);
    private MessageSource messageSource;

    protected AbstractConfigurableBeanPostProcessor(MessageSource messageSource) {
        this.messageSource = messageSource;
    }

    protected String loadMessage(String messageCode) {
        Assert.required((Object)messageCode, (String)"messageCode");
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Resolving label with code '" + messageCode + "'"));
        }
        try {
            return this.messageSource.getMessage(messageCode, null, Locale.getDefault());
        }
        catch (NoSuchMessageException e) {
            if (logger.isInfoEnabled()) {
                logger.info((Object)("The message source is unable to find message code [" + messageCode + "]. Ignoring and returning null."));
            }
            return null;
        }
    }
}

