/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.richclient.context.support;

import java.util.Locale;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanInitializationException;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.context.MessageSource;
import org.springframework.context.MessageSourceResolvable;
import org.springframework.context.NoSuchMessageException;
import org.springframework.context.support.DefaultMessageSourceResolvable;
import org.springframework.richclient.core.LabelConfigurable;
import org.springframework.richclient.core.LabelInfo;
import org.springframework.util.StringUtils;

public class LabelConfigurableBeanPostProcessor
implements BeanPostProcessor {
    public static final String LABEL_KEY = "label";
    private MessageSource messageSource;

    public LabelConfigurableBeanPostProcessor(MessageSource messageSource) {
        this.messageSource = messageSource;
    }

    public Object postProcessAfterInitialization(Object bean, String name) throws BeansException {
        if (bean instanceof LabelConfigurable) {
            LabelConfigurable configurable = (LabelConfigurable)bean;
            try {
                String label = this.messageSource.getMessage((MessageSourceResolvable)new DefaultMessageSourceResolvable(name + "." + LABEL_KEY), Locale.getDefault());
                if (StringUtils.hasText((String)label)) {
                    configurable.setLabelInfo(LabelInfo.valueOf((String)label));
                }
            }
            catch (NoSuchMessageException e) {
                throw new BeanInitializationException("Unable to initialize bean " + name, (Throwable)e);
            }
        }
        return bean;
    }

    public Object postProcessBeforeInitialization(Object bean, String name) throws BeansException {
        return bean;
    }
}

