/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.richclient.form;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import javax.swing.JComponent;
import org.springframework.binding.form.FormModel;
import org.springframework.binding.form.HierarchicalFormModel;
import org.springframework.binding.value.PropertyChangePublisher;
import org.springframework.binding.value.ValueModel;
import org.springframework.binding.value.support.ObservableList;
import org.springframework.binding.value.support.ValueHolder;
import org.springframework.richclient.command.AbstractCommand;
import org.springframework.richclient.command.ActionCommand;
import org.springframework.richclient.command.CommandGroup;
import org.springframework.richclient.form.AbstractForm;
import org.springframework.richclient.util.GuiStandardUtils;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public abstract class AbstractDetailForm
extends AbstractForm
implements PropertyChangePublisher {
    public static final int STATE_CLEAR = 0;
    public static final int STATE_EDIT = 1;
    public static final int STATE_CREATE = 2;
    public static final String EDIT_STATE_PROPERTY = "edit_state";
    private ValueHolder indexHolder = new ValueHolder((Object)new Integer(-1));
    private CommandGroup formCommandGroup;
    private ActionCommand commitCommand;
    private ActionCommand revertCommand;
    private ActionCommand cancelCommand;
    private ObservableList editableItemList;
    private int editState = 0;
    private transient PropertyChangeSupport changeSupport;

    protected AbstractDetailForm(FormModel formModel, String formId, ObservableList editableItemList) {
        super(formModel, formId);
        this.editableItemList = editableItemList;
        this.setEditableFormObjects(editableItemList);
        this.setEditingFormObjectIndexHolder((ValueModel)this.indexHolder);
    }

    public AbstractDetailForm(HierarchicalFormModel parentFormModel, String formId, ValueModel childFormObjectHolder, ObservableList masterList) {
        super(parentFormModel, formId, childFormObjectHolder);
        this.setMasterList(masterList);
        this.setEditingFormObjectIndexHolder((ValueModel)this.indexHolder);
    }

    protected void setMasterList(ObservableList masterList) {
        this.editableItemList = masterList;
        this.setEditableFormObjects(this.editableItemList);
    }

    public void setSelectedIndex(int index) {
        this.indexHolder.setValue((Object)new Integer(index));
        this.setEditState(index < 0 ? 0 : 1);
        this.updateControlsForState();
    }

    public int getSelectedIndex() {
        return this.getEditingFormObjectIndex();
    }

    public ValueHolder getEditingIndexHolder() {
        return this.indexHolder;
    }

    public void creatingNewObject() {
        this.setEditState(2);
        this.updateControlsForState();
    }

    protected void updateControlsForState() {
        boolean showCancel = false;
        boolean showRevert = false;
        switch (this.getEditState()) {
            case 2: {
                showCancel = true;
                showRevert = false;
                break;
            }
            case 0: {
                showCancel = false;
                showRevert = false;
                break;
            }
            case 1: {
                showCancel = false;
                showRevert = true;
                break;
            }
            default: {
                Assert.isTrue((boolean)false, (String)("Invalid edit state: " + this.getEditState()));
            }
        }
        this.getCancelCommand().setVisible(showCancel);
        this.getRevertCommand().setVisible(showRevert);
    }

    protected void setEditState(int editState) {
        int oldEditState = this.editState;
        this.editState = editState;
        this.updateControlsForState();
        this.firePropertyChange(EDIT_STATE_PROPERTY, oldEditState, this.editState);
    }

    public int getEditState() {
        return this.editState;
    }

    public void postCommit(FormModel formModel) {
        super.postCommit(formModel);
        this.setSelectedIndex(-1);
    }

    protected String getRevertCommandFaceDescriptorId() {
        return "revert";
    }

    protected String getCommitCommandFaceDescriptorId() {
        return "save";
    }

    protected String getCancelCommandFaceDescriptorId() {
        return "cancelNew";
    }

    protected String getNewFormObjectSecurityControllerId() {
        return null;
    }

    public ActionCommand getCancelCommand() {
        if (this.cancelCommand == null) {
            this.cancelCommand = this.createCancelCommand();
        }
        return this.cancelCommand;
    }

    protected ActionCommand createCancelCommand() {
        String commandId = this.getCancelCommandFaceDescriptorId();
        if (!StringUtils.hasText((String)commandId)) {
            return null;
        }
        ActionCommand command = new ActionCommand(commandId){

            protected void doExecuteCommand() {
                AbstractDetailForm.this.reset();
                AbstractDetailForm.this.setEnabled(false);
                AbstractDetailForm.this.setEditingNewFormObject(false);
                AbstractDetailForm.this.setEditingFormObjectIndexSilently(-1);
                AbstractDetailForm.this.setEditState(0);
                AbstractDetailForm.this.setFormObject(null);
            }
        };
        return (ActionCommand)this.getCommandConfigurer().configure((AbstractCommand)command);
    }

    protected JComponent createButtonBar() {
        this.commitCommand = this.getCommitCommand();
        this.revertCommand = this.getRevertCommand();
        this.cancelCommand = this.getCancelCommand();
        this.formCommandGroup = CommandGroup.createCommandGroup(null, (Object[])new AbstractCommand[]{this.cancelCommand, this.revertCommand, this.commitCommand});
        JComponent buttonBar = this.formCommandGroup.createButtonBar();
        GuiStandardUtils.attachDialogBorder((JComponent)buttonBar);
        return buttonBar;
    }

    public final void addPropertyChangeListener(PropertyChangeListener listener) {
        if (listener == null) {
            return;
        }
        if (this.changeSupport == null) {
            this.changeSupport = new PropertyChangeSupport((Object)this);
        }
        this.changeSupport.addPropertyChangeListener(listener);
    }

    public final void removePropertyChangeListener(PropertyChangeListener listener) {
        if (listener == null || this.changeSupport == null) {
            return;
        }
        this.changeSupport.removePropertyChangeListener(listener);
    }

    public final void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        if (listener == null) {
            return;
        }
        if (this.changeSupport == null) {
            this.changeSupport = new PropertyChangeSupport((Object)this);
        }
        this.changeSupport.addPropertyChangeListener(propertyName, listener);
    }

    public final void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        if (listener == null || this.changeSupport == null) {
            return;
        }
        this.changeSupport.removePropertyChangeListener(propertyName, listener);
    }

    protected final void firePropertyChange(String propertyName, int oldValue, int newValue) {
        if (this.changeSupport == null) {
            return;
        }
        this.changeSupport.firePropertyChange(propertyName, oldValue, newValue);
    }
}

