/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.richclient.form;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.springframework.richclient.factory.AbstractControlFactory;
import org.springframework.richclient.form.Form;
import org.springframework.richclient.form.FormUIProvider;
import org.springframework.richclient.form.binding.BindingFactory;
import org.springframework.util.Assert;

public abstract class AbstractFormUIProvider
extends AbstractControlFactory
implements FormUIProvider {
    private boolean bound = false;
    private String[] properties;
    private Map contextMap = new HashMap();

    public void bind(BindingFactory factory, Form form) {
        Assert.state((this.properties != null && this.properties.length > 0 ? 1 : 0) != 0, (String)"Properties must be set");
        this.bound = true;
        for (int i = 0; i < this.properties.length; ++i) {
            factory.bindControl(this.getComponent(this.properties[i]), this.properties[i], this.getContext(this.properties[i]));
        }
    }

    public Map getContext(String propertyPath) {
        return this.contextMap.containsKey(propertyPath) ? (Map)this.contextMap.get(propertyPath) : Collections.EMPTY_MAP;
    }

    public void setContext(String propertyPath, Map context) {
        this.contextMap.put(propertyPath, context);
    }

    public void setProperties(String[] properties) {
        Assert.state((!this.bound ? 1 : 0) != 0, (String)"You cannot set the form properties after the binding");
        this.properties = properties;
    }

    public String[] getProperties() {
        return this.properties;
    }
}

