/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.richclient.form;

import ca.odell.glazedlists.BasicEventList;
import ca.odell.glazedlists.EventList;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionListener;
import org.springframework.beans.BeanUtils;
import org.springframework.binding.form.HierarchicalFormModel;
import org.springframework.binding.form.ValidatingFormModel;
import org.springframework.binding.validation.ValidationResultsModel;
import org.springframework.binding.validation.support.DefaultValidationResultsModel;
import org.springframework.binding.value.ValueModel;
import org.springframework.binding.value.support.DeepCopyBufferedCollectionValueModel;
import org.springframework.binding.value.support.DirtyTrackingValueModel;
import org.springframework.binding.value.support.ObservableEventList;
import org.springframework.binding.value.support.ObservableList;
import org.springframework.binding.value.support.ValueHolder;
import org.springframework.richclient.command.AbstractCommand;
import org.springframework.richclient.command.ActionCommand;
import org.springframework.richclient.command.CommandGroup;
import org.springframework.richclient.dialog.ConfirmationDialog;
import org.springframework.richclient.dialog.Messagable;
import org.springframework.richclient.form.AbstractDetailForm;
import org.springframework.richclient.form.AbstractForm;
import org.springframework.richclient.form.FormModelHelper;
import org.springframework.richclient.form.SimpleValidationResultsReporter;
import org.springframework.richclient.form.ValidationResultsReporter;
import org.springframework.richclient.table.ListSelectionListenerSupport;
import org.springframework.richclient.util.GuiStandardUtils;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;

public abstract class AbstractMasterForm
extends AbstractForm {
    public static final String SELECTION_INDEX_PROPERTY = "selectionIndex";
    public static final String IS_CREATING_PROPERTY = "isCreating";
    private DirtyTrackingDCBCVM collectionVM;
    private EventList rootEventList;
    private ObservableEventList masterEventList;
    private AbstractDetailForm detailForm;
    private Class detailType;
    private ActionCommand newFormObjectCommand;
    private ActionCommand deleteCommand;
    private CommandGroup commandGroup;
    private boolean confirmDelete = true;
    private ListSelectionHandler selectionHandler = new ListSelectionHandler();
    private PropertyChangeListener parentFormPropertyChangeHandler = new ParentFormPropertyChangeHandler();

    protected AbstractMasterForm(HierarchicalFormModel parentFormModel, String property, String formId, Class detailType) {
        super(formId);
        this.detailType = detailType;
        ValueModel propertyVM = parentFormModel.getValueModel(property);
        Class collectionType = this.getMasterCollectionType(propertyVM);
        this.collectionVM = new DirtyTrackingDCBCVM(propertyVM, collectionType);
        ValidatingFormModel formModel = FormModelHelper.createChildPageFormModel((HierarchicalFormModel)parentFormModel, (String)formId, (ValueModel)this.collectionVM);
        this.setFormModel(formModel);
        propertyVM.addValueChangeListener(this.parentFormPropertyChangeHandler);
    }

    public ValueModel getCollectionValueModel() {
        return this.collectionVM;
    }

    protected Class getMasterCollectionType(ValueModel collectionPropertyVM) {
        return collectionPropertyVM.getValue().getClass();
    }

    protected void configure() {
        this.installEventList(this.getRootEventList());
        Object detailObject = BeanUtils.instantiateClass((Class)this.detailType);
        ValueHolder valueHolder = new ValueHolder(detailObject);
        this.detailForm = this.createDetailForm((HierarchicalFormModel)this.getFormModel(), (ValueModel)valueHolder, this.masterEventList);
        this.detailForm.setEnabled(false);
        this.detailForm.getFormModel().setValidating(false);
        this.detailForm.getEditingIndexHolder().addValueChangeListener((PropertyChangeListener)new EditingIndexMonitor());
        this.detailForm.addPropertyChangeListener(new EditStateMonitor());
    }

    protected abstract AbstractDetailForm createDetailForm(HierarchicalFormModel var1, ValueModel var2, ObservableList var3);

    protected void installEventList(EventList eventList) {
        this.masterEventList = new ObservableEventList(eventList);
        if (this.detailForm != null) {
            this.detailForm.setMasterList(this.masterEventList);
        }
    }

    protected EventList getRootEventList() {
        if (this.rootEventList == null) {
            this.rootEventList = (EventList)this.getFormModel().getFormObjectHolder().getValue();
        }
        return this.rootEventList;
    }

    protected void handleExternalRootEventListChange() {
        if (this.masterEventList != null) {
            this.uninstallSelectionHandler();
            if (this.detailForm != null) {
                this.detailForm.reset();
                this.detailForm.setSelectedIndex(-1);
            }
            if (this.isControlCreated()) {
                this.updateControlsForState();
            }
            this.installSelectionHandler();
        }
    }

    public List getFormData() {
        return (List)this.getFormModel().getFormObjectHolder().getValue();
    }

    public ObservableEventList getMasterEventList() {
        return this.masterEventList;
    }

    protected abstract ListSelectionModel getSelectionModel();

    protected void installSelectionHandler() {
        ListSelectionModel lsm = this.getSelectionModel();
        if (lsm != null) {
            lsm.addListSelectionListener(this.getSelectionHandler());
        }
    }

    protected void uninstallSelectionHandler() {
        ListSelectionModel lsm = this.getSelectionModel();
        if (lsm != null) {
            lsm.removeListSelectionListener(this.getSelectionHandler());
        }
    }

    public void creatingNewObject() {
        this.getSelectionModel().clearSelection();
    }

    protected ListSelectionListener getSelectionHandler() {
        return this.selectionHandler;
    }

    protected CommandGroup getCommandGroup() {
        if (this.commandGroup == null) {
            this.commandGroup = CommandGroup.createCommandGroup(null, (Object[])new AbstractCommand[]{this.getDeleteCommand(), this.getNewFormObjectCommand()});
        }
        return this.commandGroup;
    }

    protected JComponent createButtonBar() {
        JComponent buttonBar = this.getCommandGroup().createButtonBar();
        GuiStandardUtils.attachDialogBorder((JComponent)buttonBar);
        return buttonBar;
    }

    protected JPopupMenu getPopupMenu() {
        return this.getCommandGroup().createPopupMenu();
    }

    public ActionCommand getNewFormObjectCommand() {
        if (this.newFormObjectCommand == null) {
            this.newFormObjectCommand = this.createNewFormObjectCommand();
        }
        return this.newFormObjectCommand;
    }

    protected ActionCommand createNewFormObjectCommand() {
        String commandId = this.getNewFormObjectCommandId();
        if (!StringUtils.hasText((String)commandId)) {
            return null;
        }
        ActionCommand newDetailObjectCommand = new ActionCommand(commandId){

            protected void doExecuteCommand() {
                AbstractMasterForm.this.maybeCreateNewObject();
            }
        };
        String scid = this.constructSecurityControllerId(commandId);
        newDetailObjectCommand.setSecurityControllerId(scid);
        return (ActionCommand)this.getCommandConfigurer().configure((AbstractCommand)newDetailObjectCommand);
    }

    protected String getNewFormObjectCommandId() {
        return "new" + StringUtils.capitalize((String)ClassUtils.getShortName((String)(this.detailType + "Command")));
    }

    public ActionCommand getDeleteCommand() {
        if (this.deleteCommand == null) {
            this.deleteCommand = this.createDeleteCommand();
        }
        return this.deleteCommand;
    }

    protected ActionCommand createDeleteCommand() {
        String commandId = this.getDeleteCommandId();
        if (!StringUtils.hasText((String)commandId)) {
            return null;
        }
        ActionCommand deleteCommand = new ActionCommand(commandId){

            protected void doExecuteCommand() {
                AbstractMasterForm.this.maybeDeleteSelectedItems();
            }
        };
        String scid = this.constructSecurityControllerId(commandId);
        deleteCommand.setSecurityControllerId(scid);
        return (ActionCommand)this.getCommandConfigurer().configure((AbstractCommand)deleteCommand);
    }

    protected String getConfirmDeleteMessage() {
        return this.getMessage(new String[]{this.getId() + ".confirmDelete.message", "masterForm.confirmDelete.message"});
    }

    protected void maybeDeleteSelectedItems() {
        if (this.isConfirmDelete()) {
            String title = this.getMessage(new String[]{this.getId() + ".confirmDelete.title", "masterForm.confirmDelete.title"});
            String message = this.getConfirmDeleteMessage();
            ConfirmationDialog dlg = new ConfirmationDialog(title, message){

                protected void onConfirm() {
                    AbstractMasterForm.this.deleteSelectedItems();
                    AbstractMasterForm.this.getSelectionModel().clearSelection();
                }
            };
            dlg.showDialog();
        } else {
            this.deleteSelectedItems();
            this.getSelectionModel().clearSelection();
        }
    }

    protected void deleteSelectedItems() {
        int max;
        ListSelectionModel sm = this.getSelectionModel();
        if (sm.isSelectionEmpty()) {
            return;
        }
        this.detailForm.reset();
        int min = sm.getMinSelectionIndex();
        for (int index = max = sm.getMaxSelectionIndex(); index >= min; --index) {
            if (!sm.isSelectedIndex(index)) continue;
            this.getMasterEventList().remove(index);
        }
    }

    protected JButton createDeleteButton() {
        Assert.state((this.deleteCommand != null ? 1 : 0) != 0, (String)"Delete command has not been created!");
        return (JButton)this.deleteCommand.createButton();
    }

    protected String getDeleteCommandId() {
        return "delete" + StringUtils.capitalize((String)ClassUtils.getShortName((String)(this.detailType + "Command")));
    }

    protected AbstractDetailForm getDetailForm() {
        return this.detailForm;
    }

    protected void setDetailForm(AbstractDetailForm form) {
        this.detailForm = form;
    }

    protected ValidatingFormModel getDetailFormModel() {
        return this.detailForm.getFormModel();
    }

    protected Class getDetailType() {
        return this.detailType;
    }

    protected void setDetailType(Class type) {
        this.detailType = type;
    }

    public boolean isConfirmDelete() {
        return this.confirmDelete;
    }

    public void setConfirmDelete(boolean confirmDelete) {
        this.confirmDelete = confirmDelete;
    }

    protected void maybeCreateNewObject() {
        if (this.getDetailForm().isEditingNewFormObject()) {
            return;
        }
        final ActionCommand detailNewObjectCommand = this.detailForm.getNewFormObjectCommand();
        if (this.getDetailForm().isDirty()) {
            String title = this.getMessage(new String[]{this.getId() + ".dirtyNew.title", "masterForm.dirtyNew.title"});
            String message = this.getMessage(new String[]{this.getId() + ".dirtyNew.message", "masterForm.dirtyNew.message"});
            ConfirmationDialog dlg = new ConfirmationDialog(title, message){

                protected void onConfirm() {
                    detailNewObjectCommand.execute();
                    AbstractMasterForm.this.creatingNewObject();
                    AbstractMasterForm.this.detailForm.creatingNewObject();
                }
            };
            dlg.showDialog();
        } else {
            detailNewObjectCommand.execute();
            this.creatingNewObject();
            this.detailForm.creatingNewObject();
        }
    }

    protected void updateControlsForState() {
        int state = this.getDetailForm().getEditState();
        boolean isCreating = state == 2;
        this.getDeleteCommand().setEnabled(this.getDetailForm().getEditingFormObjectIndex() >= 0);
        this.getNewFormObjectCommand().setEnabled(!isCreating);
        this.getDetailFormModel().setValidating(state != 0);
    }

    public ValidationResultsReporter newSingleLineResultsReporter(Messagable messageReceiver) {
        DefaultValidationResultsModel validationResultsModel = new DefaultValidationResultsModel();
        validationResultsModel.add(this.getFormModel().getValidationResults());
        validationResultsModel.add(this.getDetailFormModel().getValidationResults());
        SimpleValidationResultsReporter reporter = new SimpleValidationResultsReporter((ValidationResultsModel)validationResultsModel, messageReceiver);
        return reporter;
    }

    private class DirtyTrackingDCBCVM
    extends DeepCopyBufferedCollectionValueModel
    implements DirtyTrackingValueModel {
        private boolean dirty;
        private boolean oldDirty;

        public DirtyTrackingDCBCVM(ValueModel wrappedModel, Class wrappedType) {
            super(wrappedModel, wrappedType);
            this.dirty = false;
            this.oldDirty = false;
            this.dirty = false;
        }

        protected ObservableList createBufferedListModel() {
            return new ObservableEventList((EventList)new BasicEventList());
        }

        public void setValue(Object value) {
            super.setValue(value);
            if (value == this.getWrappedValueModel().getValue()) {
                this.dirty = false;
                this.valueUpdated();
            }
        }

        protected void fireListModelChanged() {
            super.fireListModelChanged();
            this.dirty = true;
            this.valueUpdated();
        }

        public boolean isDirty() {
            return this.dirty;
        }

        public void clearDirty() {
            this.dirty = false;
            this.valueUpdated();
        }

        public void revertToOriginal() {
            this.revert();
        }

        protected void valueUpdated() {
            boolean dirty = this.isDirty();
            if (this.oldDirty != dirty) {
                this.oldDirty = dirty;
                this.firePropertyChange("dirty", !dirty, dirty);
            }
        }
    }

    private class ParentFormPropertyChangeHandler
    implements PropertyChangeListener {
        private ParentFormPropertyChangeHandler() {
        }

        public void propertyChange(PropertyChangeEvent evt) {
            AbstractMasterForm.this.handleExternalRootEventListChange();
        }
    }

    private class EditStateMonitor
    implements PropertyChangeListener {
        private EditStateMonitor() {
        }

        public void propertyChange(PropertyChangeEvent evt) {
            AbstractMasterForm.this.updateControlsForState();
        }
    }

    private class EditingIndexMonitor
    implements PropertyChangeListener {
        private EditingIndexMonitor() {
        }

        public void propertyChange(PropertyChangeEvent evt) {
            AbstractMasterForm.this.updateControlsForState();
        }
    }

    protected class ListSelectionHandler
    extends ListSelectionListenerSupport {
        protected ListSelectionHandler() {
        }

        protected void onNoSelection() {
            this.maybeChangeSelection(-1);
        }

        protected void onSingleSelection(int index) {
            this.maybeChangeSelection(index);
        }

        protected void maybeChangeSelection(final int newIndex) {
            if (newIndex == AbstractMasterForm.this.getDetailForm().getSelectedIndex()) {
                return;
            }
            if (AbstractMasterForm.this.getDetailForm().isDirty()) {
                String title = AbstractMasterForm.this.getMessage(new String[]{AbstractMasterForm.this.getId() + ".dirtyChange.title", "masterForm.dirtyChange.title"});
                String message = AbstractMasterForm.this.getMessage(new String[]{AbstractMasterForm.this.getId() + ".dirtyChange.message", "masterForm.dirtyChange.message"});
                ConfirmationDialog dlg = new ConfirmationDialog(title, message){

                    protected void onConfirm() {
                        AbstractMasterForm.this.getDetailForm().setSelectedIndex(newIndex);
                    }

                    protected void onCancel() {
                        super.onCancel();
                        if (AbstractMasterForm.this.getDetailForm().isEditingNewFormObject()) {
                            AbstractMasterForm.this.getSelectionModel().clearSelection();
                        } else {
                            int index = AbstractMasterForm.this.getDetailForm().getSelectedIndex();
                            AbstractMasterForm.this.getSelectionModel().setSelectionInterval(index, index);
                        }
                    }
                };
                dlg.showDialog();
            } else {
                AbstractMasterForm.this.getDetailForm().setSelectedIndex(newIndex);
            }
        }
    }
}

