/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.richclient.form;

import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.FilterList;
import ca.odell.glazedlists.SortedList;
import ca.odell.glazedlists.matchers.Matcher;
import ca.odell.glazedlists.matchers.MatcherEditor;
import ca.odell.glazedlists.swing.EventSelectionModel;
import ca.odell.glazedlists.swing.TableComparatorChooser;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.MouseListener;
import java.util.Comparator;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.table.TableModel;
import org.springframework.beans.support.PropertyComparator;
import org.springframework.binding.form.HierarchicalFormModel;
import org.springframework.richclient.form.AbstractMasterForm;
import org.springframework.richclient.form.binding.BindingFactory;
import org.springframework.richclient.form.binding.swing.SwingBindingFactory;
import org.springframework.richclient.form.builder.TableFormBuilder;
import org.springframework.richclient.table.support.GlazedTableModel;
import org.springframework.richclient.util.PopupMenuMouseListener;

public abstract class AbstractTableMasterForm
extends AbstractMasterForm {
    private EventList eventList;
    private JTable masterTable;
    private Matcher matcher;
    private MatcherEditor matcherEditor;
    private Comparator comparator;

    public AbstractTableMasterForm(HierarchicalFormModel parentFormModel, String property, String formId, Class detailType) {
        super(parentFormModel, property, formId, detailType);
    }

    public void setFilterMatcher(Matcher matcher) {
        this.matcher = matcher;
    }

    public Matcher getFilterMatcher() {
        return this.matcher;
    }

    public void setFilterMatcherEditor(MatcherEditor matcherEditor) {
        this.matcherEditor = matcherEditor;
    }

    public MatcherEditor getFilterMatcherEditor() {
        return this.matcherEditor;
    }

    public void setSortComparator(Comparator comparator) {
        this.comparator = comparator;
    }

    public Comparator getSortComparator() {
        return this.comparator;
    }

    public void setSortProperty(String propertyName) {
        this.setSortComparator((Comparator)new PropertyComparator(propertyName, true, true));
    }

    protected JComponent createFormControl() {
        this.configure();
        this.eventList = this.getRootEventList();
        if (this.matcher != null) {
            this.eventList = new FilterList(this.eventList, this.matcher);
        } else if (this.matcherEditor != null) {
            this.eventList = new FilterList(this.eventList, this.matcherEditor);
        }
        SortedList sortedList = null;
        if (this.comparator != null) {
            sortedList = new SortedList(this.eventList, this.comparator);
            this.eventList = sortedList;
        }
        this.installEventList(this.eventList);
        this.masterTable = this.createTable(this.createTableModel());
        if (this.comparator != null) {
            new TableComparatorChooser(this.masterTable, sortedList, true);
        }
        if (this.comparator != null || this.matcher != null) {
            EventSelectionModel selectionModel = new EventSelectionModel(this.eventList);
            this.masterTable.setSelectionModel((ListSelectionModel)selectionModel);
        }
        this.masterTable.setSelectionMode(2);
        this.installSelectionHandler();
        this.masterTable.addMouseListener((MouseListener)new PopupMenuMouseListener(this.getPopupMenu()));
        Dimension ps = this.getMasterTablePreferredSize(this.masterTable.getPreferredSize());
        this.masterTable.setPreferredScrollableViewportSize(ps);
        JScrollPane sp = new JScrollPane(this.masterTable);
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());
        panel.add((Component)sp, "Center");
        panel.add((Component)this.createButtonBar(), "South");
        JSplitPane splitter = new JSplitPane(0);
        splitter.add(panel);
        splitter.add(this.getDetailForm().getControl());
        splitter.setResizeWeight(1.0);
        SwingBindingFactory sbf = (SwingBindingFactory)this.getBindingFactory();
        TableFormBuilder formBuilder = new TableFormBuilder((BindingFactory)sbf);
        formBuilder.getLayoutBuilder().cell((JComponent)splitter, "align=default,default rowSpec=fill:default:g");
        this.updateControlsForState();
        return formBuilder.getForm();
    }

    protected JTable createTable(TableModel tableModel) {
        return this.getComponentFactory().createTable(tableModel);
    }

    protected TableModel createTableModel() {
        return new GlazedTableModel(this.eventList, this.getColumnPropertyNames(), this.getId()){

            protected boolean isEditable(Object row, int column) {
                return false;
            }
        };
    }

    protected Dimension getMasterTablePreferredSize(Dimension currentSize) {
        return currentSize;
    }

    protected ListSelectionModel getSelectionModel() {
        return this.masterTable != null ? this.masterTable.getSelectionModel() : null;
    }

    protected abstract String[] getColumnPropertyNames();

    public void creatingNewObject() {
        this.getSelectionModel().clearSelection();
    }

    protected EventList getEventList() {
        return this.eventList;
    }

    protected void setEventList(EventList list) {
        this.eventList = list;
    }

    protected JTable getMasterTable() {
        return this.masterTable;
    }

    protected TableModel getMasterTableModel() {
        return this.getMasterTable() != null ? this.getMasterTable().getModel() : null;
    }
}

