/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.richclient.form.binding.swing;

import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.util.Map;
import javax.swing.JComponent;
import org.springframework.binding.form.FormModel;
import org.springframework.richclient.form.binding.Binding;
import org.springframework.richclient.form.binding.support.AbstractBinder;
import org.springframework.richclient.form.binding.swing.NumberBinding;
import org.springframework.richclient.swing.BigDecimalTextField;
import org.springframework.util.Assert;

public class NumberBinder
extends AbstractBinder {
    protected boolean readOnly = false;
    protected String format = null;
    protected String unformat = null;
    protected int nrOfDecimals = 2;
    protected int nrOfNonDecimals = 10;
    protected boolean negativeSign = true;
    protected String leftDecoration = null;
    protected String rightDecoration = null;
    protected BigDecimal shiftFactor = null;
    protected Integer scale = null;
    protected int alignment = 4;

    public NumberBinder() {
        super(BigDecimal.class);
    }

    public NumberBinder(Class requiredSourceClass) {
        super(requiredSourceClass);
    }

    public void setReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
    }

    public void setLeftDecoration(String leftDecoration) {
        this.leftDecoration = leftDecoration;
    }

    public void setRightDecoration(String rightDecoration) {
        this.rightDecoration = rightDecoration;
    }

    public void setFormat(String format) {
        this.format = format;
    }

    public void setUnformat(String unformat) {
        this.unformat = unformat;
    }

    public void setNrOfDecimals(int nrOfDecimals) {
        this.nrOfDecimals = nrOfDecimals;
    }

    public void setNrOfNonDecimals(int nrOfNonDecimals) {
        this.nrOfNonDecimals = nrOfNonDecimals;
    }

    public void setNegativeSign(boolean negativeSign) {
        this.negativeSign = negativeSign;
    }

    public void setShiftFactor(BigDecimal shiftFactor) {
        Assert.isTrue((this.getRequiredSourceClass() == BigDecimal.class ? 1 : 0) != 0);
        this.shiftFactor = shiftFactor;
    }

    public void setScale(Integer scale) {
        this.scale = scale;
    }

    public void setAlignment(int alignment) {
        this.alignment = alignment;
    }

    protected JComponent createControl(Map context) {
        BigDecimalTextField component = null;
        if (this.format == null) {
            component = new BigDecimalTextField(this.nrOfNonDecimals, this.nrOfDecimals, this.negativeSign, this.getRequiredSourceClass());
        }
        if (component == null && this.unformat == null) {
            component = new BigDecimalTextField(this.nrOfNonDecimals, this.nrOfDecimals, this.negativeSign, this.getRequiredSourceClass(), new DecimalFormat(this.format));
        }
        if (component == null) {
            component = new BigDecimalTextField(this.nrOfNonDecimals, this.nrOfDecimals, this.negativeSign, this.getRequiredSourceClass(), new DecimalFormat(this.format), new DecimalFormat(this.unformat));
        }
        if (this.scale != null) {
            component.setScale(this.scale);
        }
        component.setHorizontalAlignment(this.alignment);
        return component;
    }

    protected Binding doBind(JComponent control, FormModel formModel, String formPropertyPath, Map context) {
        Assert.isTrue((boolean)(control instanceof BigDecimalTextField), (String)"Control must be an instance of BigDecimalTextField.");
        return new NumberBinding(this.getRequiredSourceClass(), (BigDecimalTextField)control, this.readOnly, this.leftDecoration, this.rightDecoration, this.shiftFactor, this.nrOfDecimals + this.nrOfNonDecimals, formModel, formPropertyPath);
    }
}

