/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.richclient.form.builder;

import java.awt.BorderLayout;
import java.awt.event.MouseEvent;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextPane;
import javax.swing.text.DefaultCaret;
import javax.swing.text.EditorKit;
import javax.swing.text.Element;
import javax.swing.text.View;
import javax.swing.text.ViewFactory;
import javax.swing.text.html.FormView;
import javax.swing.text.html.HTML;
import javax.swing.text.html.HTMLEditorKit;
import org.springframework.richclient.form.binding.BindingFactory;
import org.springframework.richclient.form.builder.AbstractFormBuilder;
import org.springframework.richclient.text.HtmlPane;
import org.springframework.richclient.text.SynchronousHTMLEditorKit;

public class HtmlFormBuilder
extends AbstractFormBuilder {
    private JPanel panel;
    private JTextPane htmlPane;
    private Map formViewMap = new HashMap();
    protected boolean inLink;

    public HtmlFormBuilder(BindingFactory bindingFactory, String html) {
        super(bindingFactory);
        this.panel = new JPanel(new BorderLayout());
        this.htmlPane = new HtmlPane();
        this.panel.add(this.htmlPane);
        this.htmlPane.setEditorKit((EditorKit)((Object)new InternalHTMLEditorKit()));
        this.htmlPane.setFocusCycleRoot(false);
        this.htmlPane.setCaret(new DefaultCaret(){

            public void mouseDragged(MouseEvent e) {
            }

            public void mouseMoved(MouseEvent e) {
            }

            public void mouseClicked(MouseEvent e) {
            }
        });
        this.setHtml(html);
    }

    private void setHtml(String html) {
        this.htmlPane.setText(html);
        this.htmlPane.setEditable(false);
        Iterator i = this.formViewMap.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry entry = i.next();
            Element element = (Element)entry.getKey();
            FormView view = (FormView)entry.getValue();
            String propertyName = (String)element.getAttributes().getAttribute(HTML.getAttributeKey("id"));
            if (propertyName == null) continue;
            JComponent comp = (JComponent)view.getComponent();
            this.getBindingFactory().bindControl(comp, propertyName);
            if (!(comp instanceof JCheckBox)) continue;
            ((JCheckBox)comp).setOpaque(false);
        }
    }

    public JComponent getForm() {
        return this.panel;
    }

    private class InternalHTMLEditorKit
    extends SynchronousHTMLEditorKit {
        private InternalHTMLEditorKit() {
        }

        public ViewFactory getViewFactory() {
            return new HTMLEditorKit.HTMLFactory(){

                public View create(Element elem) {
                    View view = super.create(elem);
                    if (view instanceof FormView) {
                        HtmlFormBuilder.this.formViewMap.put(elem, view);
                    }
                    return view;
                }
            };
        }
    }
}

