/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.richclient.list;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Rectangle;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.event.TableModelListener;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import org.springframework.richclient.list.DefaultTableListModel;
import org.springframework.richclient.list.TableListModel;
import org.springframework.util.Assert;

public class TableListCellRenderer
extends JTable
implements ListCellRenderer {
    protected static Border noFocusBorder = new EmptyBorder(1, 1, 1, 1);
    private static final Border SAFE_NO_FOCUS_BORDER = new EmptyBorder(1, 1, 1, 1);
    private ListCellRenderer cellRenderer = new DefaultListCellRenderer();
    private final JPanel headerPanel = new JPanel(new BorderLayout(0, 0));

    public TableListCellRenderer() {
        this(new DefaultTableListModel());
    }

    public TableListCellRenderer(TableListModel model) {
        this(model, null);
    }

    public TableListCellRenderer(TableListModel model, TableColumnModel columnModel) {
        super(new TableListCellRendererModel(model), columnModel);
        this.setSelectionMode(0);
        this.setOpaque(true);
        this.setBorder(TableListCellRenderer.getNoFocusBorder());
        this.headerPanel.add((Component)this.getTableHeader(), "North");
    }

    public TableListModel getTableListModel() {
        return this.getTableListCellRendererModel().getListModel();
    }

    public void setTableListModel(TableListModel model) {
        this.getTableListCellRendererModel().setListModel(model);
    }

    public void setModel(TableModel dataModel) {
        Assert.isInstanceOf((Class)TableListCellRendererModel.class, (Object)dataModel);
        super.setModel(dataModel);
    }

    private TableListCellRendererModel getTableListCellRendererModel() {
        return (TableListCellRendererModel)super.getModel();
    }

    private static Border getNoFocusBorder() {
        if (System.getSecurityManager() != null) {
            return SAFE_NO_FOCUS_BORDER;
        }
        return noFocusBorder;
    }

    public void setTableHeader(JTableHeader tableHeader) {
        super.setTableHeader(tableHeader);
        if (this.headerPanel != null) {
            if (tableHeader == null) {
                this.headerPanel.removeAll();
            } else {
                this.headerPanel.add((Component)tableHeader, "North");
            }
        }
    }

    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        if (index == -1) {
            Component comp = this.cellRenderer.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
            return comp;
        }
        this.getTableListCellRendererModel().setRow(index);
        this.setComponentOrientation(list.getComponentOrientation());
        if (isSelected) {
            this.setBackground(list.getSelectionBackground());
            this.setForeground(list.getSelectionForeground());
        } else {
            this.setBackground(list.getBackground());
            this.setForeground(list.getForeground());
        }
        this.setEnabled(list.isEnabled());
        this.setFont(list.getFont());
        Border border = null;
        if (cellHasFocus) {
            if (isSelected) {
                border = UIManager.getBorder("List.focusSelectedCellHighlightBorder");
            }
            if (border == null) {
                border = UIManager.getBorder("List.focusCellHighlightBorder");
            }
        } else {
            border = TableListCellRenderer.getNoFocusBorder();
        }
        this.setBorder(border);
        if (index == 0) {
            this.headerPanel.add(this);
            return this.headerPanel;
        }
        return this;
    }

    public void validate() {
    }

    protected void validateTree() {
    }

    public void revalidate() {
    }

    public void repaint(long tm, int x, int y, int width, int height) {
    }

    public void repaint(Rectangle r) {
    }

    protected void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
    }

    public void firePropertyChange(String propertyName, byte oldValue, byte newValue) {
    }

    public void firePropertyChange(String propertyName, char oldValue, char newValue) {
    }

    public void firePropertyChange(String propertyName, short oldValue, short newValue) {
    }

    public void firePropertyChange(String propertyName, int oldValue, int newValue) {
    }

    public void firePropertyChange(String propertyName, long oldValue, long newValue) {
    }

    public void firePropertyChange(String propertyName, float oldValue, float newValue) {
    }

    public void firePropertyChange(String propertyName, double oldValue, double newValue) {
    }

    public void firePropertyChange(String propertyName, boolean oldValue, boolean newValue) {
    }

    private static class TableListCellRendererModel
    implements TableModel {
        private int row;
        private TableListModel listModel;

        public TableListCellRendererModel(TableListModel model) {
            this.listModel = model;
        }

        public TableListModel getListModel() {
            return this.listModel;
        }

        public void setListModel(TableListModel model) {
            this.listModel = model;
        }

        public int getRowCount() {
            return 1;
        }

        public void setRow(int row) {
            this.row = row;
        }

        public Object getValueAt(int aRow, int aColumn) {
            return this.listModel.getValueAt(this.row, aColumn);
        }

        public boolean isCellEditable(int row, int column) {
            return false;
        }

        public int getColumnCount() {
            return this.listModel.getColumnCount();
        }

        public void addTableModelListener(TableModelListener l) {
        }

        public Class getColumnClass(int columnIndex) {
            return this.listModel.getColumnClass(columnIndex);
        }

        public String getColumnName(int columnIndex) {
            return this.listModel.getColumnName(columnIndex);
        }

        public void removeTableModelListener(TableModelListener l) {
        }

        public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        }
    }
}

