/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.richclient.preference;

import java.awt.Component;
import javax.swing.JComponent;
import org.springframework.richclient.command.ActionCommand;
import org.springframework.richclient.command.CommandGroup;
import org.springframework.richclient.dialog.AbstractDialogPage;
import org.springframework.richclient.layout.GridBagLayoutBuilder;
import org.springframework.richclient.preference.PreferenceDialog;
import org.springframework.richclient.settings.Settings;
import org.springframework.richclient.util.GuiStandardUtils;
import org.springframework.util.Assert;

public abstract class PreferencePage
extends AbstractDialogPage {
    private boolean createApplyAndDefaultButtons = true;
    private PreferencePage parent;
    private PreferenceDialog preferenceDialog;
    private ActionCommand restoreDefaultsCommand;
    private ActionCommand applyCommand;

    public PreferencePage(String id) {
        super(id);
    }

    public PreferencePage(String id, boolean autoconfigure) {
        super(id, autoconfigure);
    }

    protected ActionCommand[] getCommands() {
        return new ActionCommand[]{this.getRestoreDefaultsCommand(), this.getApplyCommand()};
    }

    protected ActionCommand getApplyCommand() {
        if (this.applyCommand == null) {
            this.applyCommand = new ActionCommand("applyCommand"){

                public void doExecuteCommand() {
                    PreferencePage.this.onApply();
                }
            };
        }
        return this.applyCommand;
    }

    protected ActionCommand getRestoreDefaultsCommand() {
        if (this.restoreDefaultsCommand == null) {
            this.restoreDefaultsCommand = new ActionCommand("restoreDefaultsCommand"){

                public void doExecuteCommand() {
                    PreferencePage.this.onDefaults();
                }
            };
        }
        return this.restoreDefaultsCommand;
    }

    protected JComponent createButtons() {
        CommandGroup commandGroup = CommandGroup.createCommandGroup(null, (Object[])this.getCommands());
        JComponent buttonBar = commandGroup.createButtonBar();
        GuiStandardUtils.attachDialogBorder((JComponent)buttonBar);
        return buttonBar;
    }

    protected abstract JComponent createContents();

    protected JComponent createControl() {
        GridBagLayoutBuilder builder = new GridBagLayoutBuilder();
        JComponent buttonPanel = null;
        if (this.createApplyAndDefaultButtons) {
            buttonPanel = this.createButtons();
        }
        JComponent contents = this.createContents();
        Assert.notNull((Object)contents, (String)"Contents cannot be null.");
        builder.append((Component)contents, 1, 1, true, true);
        if (this.createApplyAndDefaultButtons) {
            builder.nextLine();
            builder.append((Component)buttonPanel);
        }
        return builder.getPanel();
    }

    public PreferencePage getParent() {
        return this.parent;
    }

    protected Settings getSettings() {
        return this.preferenceDialog.getSettings();
    }

    protected void onApply() {
        this.onFinish();
    }

    protected void onDefaults() {
    }

    protected boolean onFinish() {
        return true;
    }

    public void setCreateApplyAndDefaultButtons(boolean create) {
        this.createApplyAndDefaultButtons = create;
    }

    public boolean getCreateApplyAndDefaultButtons() {
        return this.createApplyAndDefaultButtons;
    }

    public void setParent(PreferencePage parent) {
        this.parent = parent;
    }

    public void setPreferenceDialog(PreferenceDialog dialog) {
        Assert.notNull((Object)((Object)dialog));
        this.preferenceDialog = dialog;
    }

    public void setPageComplete(boolean pageComplete) {
        if (this.applyCommand != null) {
            this.applyCommand.setEnabled(pageComplete);
        }
        super.setPageComplete(pageComplete);
    }
}

