/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.richclient.selection.dialog;

import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.FilterList;
import ca.odell.glazedlists.TextFilterator;
import ca.odell.glazedlists.matchers.MatcherEditor;
import ca.odell.glazedlists.swing.TextComponentMatcherEditor;
import java.awt.Window;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.JComponent;
import javax.swing.JTextField;
import javax.swing.text.JTextComponent;
import org.springframework.richclient.layout.TableLayoutBuilder;
import org.springframework.richclient.selection.dialog.ListSelectionDialog;
import org.springframework.richclient.text.TextComponentPopup;

public class FilterListSelectionDialog
extends ListSelectionDialog {
    private TextFilterator filterator;
    private FilterList filterList;

    public void setFilterator(TextFilterator filterator) {
        this.filterator = filterator;
    }

    public FilterListSelectionDialog(String title, Window parent, FilterList filterList) {
        super(title, parent, (EventList)filterList);
        this.filterList = filterList;
    }

    protected JComponent createSelectionComponent() {
        TableLayoutBuilder builder = new TableLayoutBuilder();
        JComponent filterComponent = this.createFilterComponent();
        builder.cell(filterComponent);
        builder.row();
        builder.relatedGapRow();
        builder.cell(super.createSelectionComponent());
        return builder.getPanel();
    }

    protected JComponent createFilterComponent() {
        JTextField filter = new JTextField();
        this.filterList.setMatcherEditor((MatcherEditor)new TextComponentMatcherEditor((JTextComponent)filter, this.filterator));
        TextComponentPopup.attachPopup((JTextComponent)filter);
        filter.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 40) {
                    FilterListSelectionDialog.this.getList().requestFocusInWindow();
                } else if (e.getKeyCode() == 10 && FilterListSelectionDialog.this.getFinishCommand().isEnabled()) {
                    FilterListSelectionDialog.this.getFinishCommand().execute();
                }
            }
        });
        return filter;
    }
}

