/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.richclient.settings.jdbc;

import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.sql.DataSource;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.richclient.settings.AbstractSettings;
import org.springframework.richclient.settings.Settings;

public class JdbcSettings
extends AbstractSettings {
    private DataSource dataSource;
    private Integer id;
    private String user;
    private Map values = new HashMap();
    private Set remove = new HashSet();
    private Set add = new HashSet();
    private Set update = new HashSet();
    private String[] childKeys;

    public JdbcSettings(DataSource ds, String user, Integer id, String key) {
        this(null, ds, user, id, key);
    }

    public JdbcSettings(JdbcSettings parent, DataSource ds, String user, Integer id, String key) {
        super(parent, key);
        this.id = id;
        this.dataSource = ds;
        this.user = user;
    }

    protected boolean internalContains(String key) {
        return this.values.containsKey(key);
    }

    protected String[] internalGetChildSettings() {
        if (this.childKeys == null) {
            this.loadChildKeys();
        }
        return this.childKeys;
    }

    protected Settings internalCreateChild(String key) {
        return new JdbcSettings(this, this.dataSource, this.user, null, key);
    }

    protected void internalSet(String key, String value) {
        boolean isNew = !this.values.containsKey(key) || this.add.contains(key);
        this.values.put(key, value);
        if (isNew) {
            this.add.add(key);
        } else {
            this.update.add(key);
        }
        this.remove.remove(key);
    }

    protected String internalGet(String key) {
        return (String)this.values.get(key);
    }

    protected void internalRemove(String key) {
        this.values.remove(key);
        if (!this.add.contains(key)) {
            this.remove.add(key);
        }
        this.update.remove(key);
        this.add.remove(key);
    }

    public String[] getKeys() {
        return this.values.keySet().toArray(new String[0]);
    }

    public Integer getId() {
        return this.id;
    }

    public void save() throws IOException {
        String key;
        Iterator iter;
        if (this.getParent() != null) {
            this.getParent().save();
        }
        JdbcTemplate template = new JdbcTemplate(this.dataSource);
        if (this.id == null) {
            JdbcSettings parent = (JdbcSettings)this.getParent();
            template.update("INSERT INTO SETTINGS (KEY, PARENT, USER) VALUES (?, ?, ?)", new Object[]{this.getName(), parent == null ? null : parent.getId(), this.user});
            this.id = template.queryForInt("SELECT MAX(ID) FROM SETTINGS");
        } else {
            iter = this.remove.iterator();
            while (iter.hasNext()) {
                key = (String)iter.next();
                template.update("REMOVE FROM SETTINGS_VALUES WHERE SETTINGS_ID=? AND KEY=?", new Object[]{this.id, key});
            }
            iter = this.update.iterator();
            while (iter.hasNext()) {
                key = (String)iter.next();
                template.update("UPDATE SETTINGS_VALUES SET VALUE=? WHERE SETTINGS_ID=? AND KEY=?", new Object[]{this.values.get(key), this.id, key});
            }
        }
        iter = this.add.iterator();
        while (iter.hasNext()) {
            key = (String)iter.next();
            template.update("INSERT INTO SETTINGS_VALUES (SETTINGS_ID, KEY, VALUE) VALUES (?, ?, ?)", new Object[]{this.id, key, this.values.get(key)});
        }
        this.remove.clear();
        this.update.clear();
        this.add.clear();
    }

    public void load() throws IOException {
        if (this.id == null) {
            return;
        }
        JdbcTemplate template = new JdbcTemplate(this.dataSource);
        List entries = template.queryForList("SELECT KEY, VALUE FROM SETTINGS_VALUES WHERE SETTINGS_ID=?", new Object[]{this.id});
        Iterator iter = entries.iterator();
        while (iter.hasNext()) {
            Map entry = (Map)iter.next();
            this.values.put(entry.get("KEY"), entry.get("VALUE"));
        }
    }

    private void loadChildKeys() {
        JdbcTemplate template = new JdbcTemplate(this.dataSource);
        List keys = template.queryForList("SELECT KEY FROM SETTINGS WHERE PARENT=" + this.id, String.class);
        this.childKeys = keys.toArray(new String[keys.size()]);
    }

    public String getUser() {
        return this.user;
    }

    public void internalRemoveSettings() {
        if (this.id != null) {
            for (int i = 0; i < this.childKeys.length; ++i) {
                this.getSettings(this.childKeys[i]).removeSettings();
            }
            JdbcTemplate template = new JdbcTemplate(this.dataSource);
            template.update("DELETE FROM SETTINGS_VALUES WHERE SETTINGS_ID=?", new Object[]{this.id});
            template.update("DELETE FROM SETTINGS WHERE ID=?", new Object[]{this.id});
            this.id = null;
        }
        this.values.clear();
        this.remove.clear();
        this.add.clear();
        this.update.clear();
    }
}

