/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.richclient.settings.jdbc;

import java.io.IOException;
import java.util.Map;
import javax.sql.DataSource;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.dao.IncorrectResultSizeDataAccessException;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.richclient.settings.Settings;
import org.springframework.richclient.settings.SettingsException;
import org.springframework.richclient.settings.SettingsFactory;
import org.springframework.richclient.settings.jdbc.JdbcSettings;
import org.springframework.richclient.settings.jdbc.UserNameProvider;
import org.springframework.util.Assert;

public class JdbcSettingsFactory
implements SettingsFactory,
InitializingBean {
    private DataSource dataSource;
    private UserNameProvider userNameProvider;

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }

    public Settings createSettings(String key) throws SettingsException {
        try {
            JdbcTemplate template = new JdbcTemplate(this.dataSource);
            Map result = template.queryForMap("SELECT * FROM SETTINGS WHERE KEY=? AND USER=?", new Object[]{key, this.userNameProvider.getUser()});
            JdbcSettings settings = new JdbcSettings(this.dataSource, this.userNameProvider.getUser(), (Integer)result.get("ID"), key);
            settings.load();
            return settings;
        }
        catch (IncorrectResultSizeDataAccessException e) {
            return new JdbcSettings(this.dataSource, this.userNameProvider.getUser(), null, key);
        }
        catch (IOException e) {
            throw new SettingsException("Unable to create settings with name " + key, e);
        }
    }

    public void setUserNameProvider(UserNameProvider userNameProvider) {
        this.userNameProvider = userNameProvider;
    }

    public UserNameProvider getUserNameProvider() {
        return this.userNameProvider;
    }

    public void afterPropertiesSet() throws Exception {
        Assert.notNull((Object)this.userNameProvider, (String)"UserNameProvider must be set");
        Assert.notNull((Object)this.dataSource, (String)"DataSource must be set");
    }
}

