/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.richclient.settings.support;

import javax.swing.JSplitPane;
import org.springframework.richclient.settings.Settings;
import org.springframework.richclient.settings.support.Memento;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class SplitPaneMemento
implements Memento {
    private JSplitPane splitPane;
    private String key;

    public SplitPaneMemento(JSplitPane splitPane) {
        this(splitPane, null);
    }

    public SplitPaneMemento(JSplitPane splitPane, String key) {
        Assert.notNull((Object)splitPane, (String)"SplitPane cannot be null");
        Assert.isTrue((StringUtils.hasText((String)key) || StringUtils.hasText((String)splitPane.getName()) ? 1 : 0) != 0, (String)"Key is empty or splitpane has no name");
        if (!StringUtils.hasText((String)key)) {
            key = splitPane.getName();
        }
        this.splitPane = splitPane;
        this.key = key;
    }

    public void saveState(Settings settings) {
        settings.setInt(this.key + ".dividerLocation", this.splitPane.getDividerLocation());
    }

    public void restoreState(Settings settings) {
        if (settings.contains(this.key + ".dividerLocation")) {
            this.splitPane.setDividerLocation(settings.getInt(this.key + ".dividerLocation"));
        }
    }

    public JSplitPane getSplitPane() {
        return this.splitPane;
    }

    public String getKey() {
        return this.key;
    }
}

