/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.richclient.settings.support;

import javax.swing.JTree;
import org.springframework.richclient.settings.Settings;
import org.springframework.richclient.settings.support.ArrayUtil;
import org.springframework.richclient.settings.support.Memento;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class TreeMemento
implements Memento {
    private static final String EXPANSION_STATE = "expansionState";
    private static final String SELECTED_ROWS = "selectedRows";
    private String key;
    private JTree tree;

    public TreeMemento(JTree tree) {
        this(tree, null);
    }

    public TreeMemento(JTree tree, String key) {
        Assert.notNull((Object)tree, (String)"tree cannot be null");
        Assert.isTrue((StringUtils.hasText((String)key) || StringUtils.hasText((String)tree.getName()) ? 1 : 0) != 0, (String)"Key is empty or tree has no name");
        if (!StringUtils.hasText((String)key)) {
            key = tree.getName();
        }
        this.tree = tree;
        this.key = key;
    }

    public JTree getTree() {
        return this.tree;
    }

    public String getKey() {
        return this.key;
    }

    public void restoreState(Settings settings) {
        this.restoreExpansionState(settings);
        this.restoreSelectionState(settings);
    }

    public void saveState(Settings settings) {
        this.saveExpansionState(settings);
        this.saveSelectionState(settings);
    }

    void saveExpansionState(Settings settings) {
        int rowCount = this.tree.getRowCount();
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < rowCount; ++i) {
            sb.append(this.tree.isExpanded(i) ? 1 : 0);
            if (i >= rowCount - 1) continue;
            sb.append(",");
        }
        settings.setString(this.key + "." + EXPANSION_STATE, sb.toString());
    }

    void restoreExpansionState(Settings settings) {
        String expansionKey = this.key + "." + EXPANSION_STATE;
        if (settings.contains(expansionKey)) {
            String[] states = settings.getString(expansionKey).split(",");
            try {
                int[] expansionStates = ArrayUtil.toIntArray(states);
                for (int i = 0; i < expansionStates.length; ++i) {
                    if (expansionStates[i] != 1) continue;
                    this.tree.expandRow(i);
                }
            }
            catch (IllegalArgumentException e) {
                // empty catch block
            }
        }
    }

    void saveSelectionState(Settings settings) {
        String selectionString;
        String selectionKey = this.key + "." + SELECTED_ROWS;
        if (settings.contains(selectionKey)) {
            settings.remove(selectionKey);
        }
        if (this.tree.getSelectionCount() > 0 && (selectionString = ArrayUtil.asIntervalString(this.tree.getSelectionRows())).length() > 0) {
            settings.setString(selectionKey, selectionString);
        }
    }

    void restoreSelectionState(Settings settings) {
        String selection;
        this.tree.getSelectionModel().clearSelection();
        String selectionKey = this.key + "." + SELECTED_ROWS;
        if (settings.contains(selectionKey) && StringUtils.hasText((String)(selection = settings.getString(selectionKey)))) {
            String[] parts = selection.split(",");
            for (int i = 0; i < parts.length; ++i) {
                if (parts[i].indexOf(45) >= 0) {
                    String[] tmp = parts[i].split("-");
                    this.tree.addSelectionInterval(Integer.parseInt(tmp[0]), Integer.parseInt(tmp[1]));
                    continue;
                }
                int index = Integer.parseInt(parts[i]);
                this.tree.addSelectionRow(index);
            }
        }
    }
}

